<?php
require 'DB.php';
require 'funkcje_pomocnicze.php'; // Wczytanie funkcji pomocniczych wywietlajcych elementy formularza.

$db = DB::connect('mysql://mysliwy:w)mp3s@db.przyklad.com/restauracja');
if (DB::isError($db)) { die("Nie mona nawiza poczenia: " . $db->getMessage()); }

$db->setErrorHandling(PEAR_ERROR_DIE);
$db->setFetchMode(DB_FETCHMODE_ASSOC);

// Pobierz z bazy danych tablic nazw potraw.
$nazwy_potraw = array();
$res = $db->query('SELECT nazwa_potrawy FROM potrawy');
while ($wiersz = $res->fetchRow()) {
    $nazwy_potraw[] = $wiersz['nazwa_potrawy'];
}

if ($_POST['_sprawdz_czy_wyslac']) {
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        przetworz_formularz();
    }
} else {
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    global $db;

    if ($bledy) {
        print 'Musisz poprawi nastpujce bdy: <ul><li>';
        print implode('</li><li>',$bledy);
        print '</li></ul>';
    }

    // Pocztek formularza.
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
    print '<table>';


    // Menu select z potrawami.
    print '<tr><td>Potrawa:</td><td>';
    input_select('nazwa_potrawy', $_POST, $GLOBALS['nazwy_potraw']);
    print '</td></tr>';

    // Koniec formularza.
    print '<tr><td colspan="2"><input type="submit" value="Szukaj potraw"></td></tr>';
    print '</table>';
    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';
    print '</form>';
}

function sprawdz_formularz() {
    $bledy = array();

    if (! array_key_exists($_POST['nazwa_potrawy'], $GLOBALS['nazwy_potraw'])) {
        $bledy[] = 'Prosz zaznaczy poprawn potraw.';
    }

    return $bledy;
}

function przetworz_formularz() {
    global $db;

    // Przetumacz $_POST['nazwa_potrawy'] (ktra jest liczb) na nazw,
    // na przykad "Woskie orzechy".
    $nazwa_potrawy = $GLOBALS['nazwy_potraw'][ $_POST['nazwa_potrawy'] ];

    $informacja_o_potrawie = $db->getRow('SELECT id_potrawy, nazwa_potrawy, cena, czy_ostra FROM potrawy WHERE nazwa_potrawy = ?',
                             array($nazwa_potrawy));
    if (count($informacja_o_potrawie) > 0) {
        print '<ul>';
        print "<li> Identyfikator: $informacja_o_potrawie[id_potrawy]</li>";
        print "<li> Nazwa: $informacja_o_potrawie[nazwa_potrawy]</li>";
        print "<li> Cena: $informacja_o_potrawie[cena]</li>";
        print "<li> Czy jest ostra: $informacja_o_potrawie[czy_ostra]</li>";
        print '</ul>';
    } else {
        print 'Nie znaleziono adnych potraw.';
    }
}
?>
