<?php
require 'DB.php';
require 'funkcje_pomocnicze.php'; // Wczytanie funkcji pomocniczych wywietlajcych elementy formularza.

$db = DB::connect('mysql://mysliwy:w)mp3s@db.przyklad.com/restauracja');
if (DB::isError($db)) { die("Nie mona nawiza poczenia: " . $db->getMessage()); }

$db->setErrorHandling(PEAR_ERROR_DIE);
$db->setFetchMode(DB_FETCHMODE_ASSOC);

if ($_POST['_sprawdz_czy_wyslac']) {
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        przetworz_formularz();
    }
} else {
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    if ($errors) {
        print 'Musisz poprawi nastpujce bedy: <ul><li>';
        print implode('</li><li>',$bledy);
        print '</li></ul>';
    }

    // Pocztek formularza.
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
    print '<table>';

    // Cena.
    print '<tr><td>Cena:</td><td>';
    input_text('cena', $_POST);
    print '</td></tr>';

    // Koniec formularza.
    print '<tr><td colspan="2"><input type="submit" value="Szukaj potraw"></td></tr>';
    print '</table>';
    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';
    print '</form>';
}

function sprawdz_formularz() {
    $bledy = array();

    if (! is_numeric($_POST['cena'])) {
        $bledy[] = 'Prosz poda poprawn cen.';
    } elseif ($_POST['cena'] <= 0) {
        $bledy[] = 'Prosz poda cen wiksz od 0.';
    }
    return $bledy;
}

function przetworz_formularz() {
    global $db;

    $potrawy = $db->getAll('SELECT nazwa_potrawy, cena FROM potrawy WHERE cena >= ?',
                          array($_POST['cena']));
    if (count($potrawy) > 0) {
        print '<ul>';
        foreach ($potrawy as $potrawa) {
            print "<li> $potrawa[nazwa_potrawy] ($potrawa[cena])</li>";
        }
        print '</ul>';
    } else {
        print 'Nie znaleziono adnych potraw..';
    }
}
?>
