<?php
// Wczytaj funkcje pomocnicze wywietlajce elementy formularza.
require 'funkcje_pomocnicze.php';

$stany_usa = array('AL' => 'Alabama', 'AK' => 'Alaska', 'AZ' => 'Arizona',
                   'AR' => 'Arkansas', 'CA' => 'California', 'CO' => 'Colorado',
                   'CT' => 'Connecticut', 'DE' => 'Delaware', 'FL' => 'Florida',
                   'GA' => 'Georgia', 'HI' => 'Hawaii', 'ID' => 'Idaho',
                   'IL' => 'Illinois', 'IN'=> 'Indiana', 'IA' => 'Iowa',
                   'KS' => 'Kansas', 'KY' => 'Kentucky','LA' => 'Louisiana',
                   'ME' => 'Maine', 'MD' => 'Maryland', 'MA' =>'Massachusetts',
                   'MI' => 'Michigan', 'MN' => 'Minnesota', 'MS' =>'Mississippi',
                   'MO' => 'Missouri', 'MT' => 'Montana', 'NE' =>'Nebraska',
                   'NV' => 'Nevada', 'NH' => 'New Hampshire', 'NJ' => 'New Jersey',
                   'NM' => 'New Mexico', 'NY' => 'New York', 'NC' => 'North Carolina',
                   'ND' => 'North Dakota', 'OH' => 'Ohio', 'OK' => 'Oklahoma',
                   'OR' => 'Oregon', 'PA' => 'Pennsylvania', 'RI' => 'Rhode Island',
                   'SC' => 'South Carolina', 'SD' => 'South Dakota', 'TN' => 'Tennessee',
                   'TX' => 'Texas', 'UT' => 'Utah', 'VT' => 'Vermont', 'VA' => 'Virginia',
                   'WA' => 'Washington', 'DC' => 'Washington D.C.', 'WV' => 'West Virginia',
                   'WI' => 'Wisconsin', 'WY' => 'Wyoming');

if ($_POST['_sprawdz_czy_wyslac']) {
    // Jeeli funkcja sprawdz_formularz() zwrci bdy,
    // przeka je do funkcji pokaz_formularz().
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        // Wysane dane s poprawne, wic je przetwrz.
        przetworz_formularz();
    }
} else {
    // Formularz nie zosta wysany, wic go wywietl.
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {

    if ($bledy) {
        print 'Musisz poprawi nastpujce bdy: <ul><li>';
        print implode('</li><li>',$bledy);
        print '</li></ul>';
    }

    // Pocztek formularza.
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
    print '<table>';

    // Pierwszy adres.
    print '<tr><th colspan="2">Od</th></tr>';
    print '<td>Nazwisko:</td><td>';
    input_text('nazwisko_1', $_POST);
    print '</td></tr>';
    print '<tr><td>Adres zamieszkania:</td><td>';
    input_text('adres_zamieszkania_1', $_POST);
    print '</td></tr>';
    print '<tr><td>Miasto, Stan, Kod pocztowy:</td><td>';
    input_text('miasto_1', $_POST);
    print ', ';
    input_select('stan_1', $_POST, $GLOBALS['stany_usa']);
    input_text('kod_pocztowy_1', $_POST);
    print '</td></tr>';

    // Drugi adres.
    print '<tr><th colspan="2">To</th></tr>';
    print '<td>Nazwisko:</td><td>';
    input_text('nazwisko_2', $_POST);
    print '</td></tr>';
    print '<tr><td>Adres zamieszkania:</td><td>';
    input_text('adres_zamieszkania_2', $_POST);
    print '</td></tr>';
    print '<tr><td>Miasto, Stan, Kod pocztowy:</td><td>';
    input_text('miasto_2', $_POST);
    print ', ';
    input_select('state_2', $_POST, $GLOBALS['stany_usa']);
    input_text('kod_pocztowy_2', $_POST);
    print '</td></tr>';

    // Informacja o przesyce.
    print '<tr><th colspan="2">Przesyka</th></tr>';
    print '<tr><td>Wysoko:</td><td>';
    input_text('wysokosc',$_POST);
    print '</td></tr>';
    print '<tr><td>Szeroko:</td><td>';
    input_text('szerokosc',$_POST);
    print '</td></tr>';
    print '<tr><td>Dugo:</td><td>';
    input_text('dlugosc',$_POST);
    print '</td></tr>';
    print '<tr><td>Waga:</td><td>';
    input_text('waga',$_POST);
    print '</td></tr>';

    // Koniec formularza.
    print '<tr><td colspan="2"><input type="submit" value="Wylij przesyk"></td></tr>';
    print '</table>';
    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';
    print '</form>';
}

function sprawdz_formularz() {
    $bledy = array();

    // Pierwszy adres:
    // nazwisko, adres zamieszkania, miasto, s wymaganymi elementami.
    if (! strlen(trim($_POST['nazwisko_1']))) {
        $bledy[] = 'Podaj nazwisko nadawcy.';
    }
    if (! strlen(trim($_POST['adres_zamieszkania_1']))) {
        $bledy[] = 'Podaj adres zamieszkania nadawcy.';
    }
    if (! strlen(trim($_POST['miasto_1']))) {
        $bledy[] = 'Podaj miasto nadawcy.';
    }
    // Stan musi by prawidowy.
    if (! array_key_exists($_POST['state_1'], $GLOBALS['stany_usa'])) {
        $bledy[] = 'Zaznacz poprawny stan nadawcy.';
    }
    // Kod pocztowy musi si skada z piciu cyfr
    // lub z piciu cyfr i czterech dodatkowych.
    if (!preg_match('/^\d{5}(-\d{4})?$/', $_POST['kod_pocztowy_1'])) {
        $bledy[] = 'Podaj poprawny kod pocztowy nadawcy.';
    }

    // Drugi adres:
    // nazwisko, adres zamieszkania, miasto, s wymaganymi elementami.
    if (! strlen(trim($_POST['nazwisko_2']))) {
        $bledy[] = 'Podaj nazwisko odbiorcy.';
    }
    if (! strlen(trim($_POST['adres_zamieszkania_2']))) {
        $bledy[] = 'Podaj adres zamieszkania odbiorcy.';
    }
    if (! strlen(trim($_POST['miasto_2']))) {
        $bledy[] = 'Podaj miasto odbiorcy.';
    }
    // Stan musi by prawidowy.
    if (! array_key_exists($_POST['stan_2'], $GLOBALS['stany_usa'])) {
        $bledy[] = 'Zaznacz prawidowy stan, w ktrym mieszka odbiorca.';
    }
    // Kod pocztowy musi si skada z piciu cyfr
    // lub z piciu cyfr i czterech dodatkowych.
    if (!preg_match('/^\d{5}(-\d{4})?$/', $_POST['kod_pocztowy_2'])) {
        $bledy[] = 'Podaj poprawny kod pocztowy odbiorcy.';
    }

    // Przesyka:
    // kady wymiar musi posiada <= 100 cm.
    if (! strlen($_POST['wysokosc'])) {
        $bledy[] = 'Podaj wysoko przesyki.';
    }
    if ($_POST['wysokosc'] > 100) {
        $bledy[] = 'Wysoko przesyki nie moe przekracza 100 cm.';
    }
    if (! strlen($_POST['dlugosc'])) {
        $bledy[] = 'Podaj dugo przesyki.';
    }
    if ($_POST['dlugosc'] > 100) {
        $bledy[] = 'Dugo przesyki nie moe przekracza 100 cm.';
    }
    if (! strlen($_POST['szerokosc'])) {
        $bledy[] = 'Podaj szeroko przesyki.';
    }
    if ($_POST['szerokosc'] > 100) {
        $bledy[] = 'Szeroko przesyki nie moe przekracza 100 cm.';
    }
    // Waga przesyki musi by <= 75 kg.
    if (! strlen($_POST['waga'])) {
        $bledy[] = 'Prosz poda wag przesyki.';
    }
    if ($_POST['waga'] > 150) {
        $bledy[] = 'Waga przesyki nie moe przekracza 75 kg.';
    }

    return $bledy;
}

function przetworz_formularz() {
    print 'Przesyka zostaje wysana od: <br/>';
    print htmlentities($_POST['nazwisko_1']) . '<br/>';
    print htmlentities($_POST['adres_zamieszkania_1']) . '<br/>';
    print htmlentities($_POST['miasto_1']) .', '. $_POST['stan_1'] . ' ' . $_POST['kod_pocztowy_1'] . '<br/>';
    print 'Przesyka zostaje wysana do: <br/>';
    print htmlentities($_POST['nazwisko_2']) . '<br/>';
    print htmlentities($_POST['adres_zamieszkania_2']) . '<br/>';
    print htmlentities($_POST['miasto_2']) .', '. $_POST['stan_2'] . ' ' . $_POST['kod_pocztowy_2'] . '<br/>';
    print 'Wymiary przesyki to ' . htmlentities($_POST['dlugosc']) . ' x' .
        htmlentities($_POST['szerokosc']) . ' x ' . htmlentities($_POST['wysokosc']);
    print ', a jej waga to ' . htmlentities($_POST['waga']) . ' kg.';
}
?>
