<?php
$ops = array('+','-','*','/');

if ($_POST['_sprawdz_czy_wyslac']) {
    // Jeeli funkcja sprawdz_formularz() zwrci bdy,
    // przeka je do funkcji pokaz_formularz().
    if ($bledy_formularza = sprawdz_formularz()) {
        pokaz_formularz($bledy_formularza);
    } else {
        // Wysane dane s poprawne, a wic je przetwrz.
        przetworz_formularz();
    }
} else {
    // Formularz nie zosta wysany, a wic go wywietl.
    pokaz_formularz();
}

function pokaz_formularz($bledy = '') {
    if ($bledy) {
        print 'Musisz poprawi nastpujce bdy: <ul><li>';
        print implode('</li><li>',$bledy);
        print '</li></ul>';
    }

    // Pocztek formularza.
    print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';

    // Pierwszy operand.
    print '<input type="text" name="operand_1" size="5" value="';
    print htmlspecialchars($_POST['operand_1']) .'"/>';

    // Operator.
    print '<select name="operator">';
    foreach ($GLOBALS['ops'] as $op) {
        print '<option';
        if ($_POST['operator'] == $op) { print ' selected="selected"'; }
        print "> $op</option>";
    }
    print '</select>';

    // Drugi operand.
    print '<input type="text" name="operand_2" size="5" value="';
    print htmlspecialchars($_POST['operand_2']) .'"/>';

    // Przycisk wylij.
    print '<br/><input type="submit" value="Dokonaj obliczenia"/>';

    // Ukryta zmienna _sprawdz_czy_wyslac.
    print '<input type="hidden" name="_sprawdz_czy_wyslac" value="1"/>';

    // Koniec formularza.
    print '</form>';
}

function sprawdz_formularz() {
    $bledy = array();

    // Operand numer 1 musi by liczb.
    if (! strlen($_POST['operand_1'])) {
        $bledy[] = 'Prosz poda liczb dla pierwszego operandu.';
    } elseif (! floatval($_POST['operand_1']) == $_POST['operand_1']) {
        $bledy[] = "Pierwszy operand musi by liczb.";
    }
    // Operand numer 2 musi by liczb.
    if (! strlen($_POST['operand_2'])) {
        $bledy[] = ' Prosz poda liczb dla drugiego operandu.';
    } elseif (! floatval($_POST['operand_2']) == $_POST['operand_2']) {
        $bledy[] = "Drugi operand musi by liczb.";
    }
    // Operator musi by poprawny.
    if (! in_array($_POST['operator'], $GLOBALS['ops'])) {
        $bledy[] = "Prosz wybra poprawny operator.";
    }

    return $bledy;
}

function przetworz_formularz() {
    if ('+' == $_POST['operator']) {
        $wynik = $_POST['operand_1'] + $_POST['operand_2'];
    } elseif ('-' == $_POST['operator']) {
        $wynik = $_POST['operand_1'] - $_POST['operand_2'];
    } elseif ('*' == $_POST['operator']) {
        $wynik = $_POST['operand_1'] * $_POST['operand_2'];
    } elseif ('/' == $_POST['operator']) {
        $wynik = $_POST['operand_1'] / $_POST['operand_2'];
    }
    print "$_POST[operand_1] $_POST[operator] $_POST[operand_2] = $wynik ";
}
?>
