// Rozdzielamy w tablicy nazwy miasta i stanu
// i dziki temu moemy poda wielko populacji w danym stanie.
$wielkosc_populacji = array('New York'     => array('stan' => 'NY', 'pop' => 8008278),
                            'Los Angeles'  => array('stan' => 'CA', 'pop' => 3694820),
                            'Chicago'      => array('stan' => 'IL', 'pop' => 2896016),
                            'Houston'      => array('stan' => 'TX', 'pop' => 1953631),
                            'Philadelphia' => array('stan' => 'PA', 'pop' => 1517550),
                            'Phoenix'      => array('stan' => 'AZ', 'pop' => 1321045),
                            'San Diego'    => array('stan' => 'CA', 'pop' => 1223400),
                            'Dallas'       => array('stan' => 'TX', 'pop' => 1188580),
                            'San Antonio'  => array('stan' => 'TX', 'pop' => 1144646),
                            'Detroit'      => array('stan' => 'MI', 'pop' => 951270));

// Uywamy tablicy $populacja_stanu do ledzenia wielkoci populacji stanu.
$populacja_stanu = array();
$populacja_calkowita = 0;

print "<table><tr><th>Miasto</th><th>Populacja</th></tr>\n";
foreach ($wielkosc_populacji as $miasto => $info) {
    // $info w tablicy posiada dwa elementy: pop (populacja miasta)
    // oraz stan (nazwa stanu).
    $populacja_calkowita += $info['pop'];
    // Zwikszajc element $info['stan'] w $populacja_stanu przez $info['pop'],
    // ledzimy cakowit populacj stanu $info['stan'].
    $populacja_stanu[$info['stan']] += $info['pop'];
    print "<tr><td>$miasto, {$info['stan']}</td><td>{$info['pop']}</td></tr>\n";

}

// Przechodzc kolejno przez tablic $populacja_stanu,
// wywietlamy cakowit populacj dla danego stanu.
foreach ($populacja_stanu as $stan => $pop) {
    print "<tr><td>$stan</td><td>$pop</td>\n";
}
print "<tr><td>Populacja cakowita</td><td>$populacja_calkowita</td></tr>\n";
print "</table>\n";
