#!/usr/local/bin/php
<?php

/* Odczytanie argumentw */
if ($argc < 2) {
    echo "Uycie:\nphp_pobranie.php url [maks. kb/sek]\n\n";
    exit(-1);
}

/* URL, ktry ma zosta sprowadzony */
$url = $argv[1];

/* Ograniczenie przepustowoci */
if ($argc == 3) {
    $max_kb_sec = $argv[2];
} else {
    $max_kb_sec = 1000;
}


/* Kursor do kolumny 1 na xterms */
$term_sol = "\x1b[1G";
$severity_map = array (
    0 => 'info       ',
    1 => 'ostrzeenie',
    2 => 'bd       '
);

/* Funkcja zwrotna dla zdarze strumienia */
function notifier($code, $severity, $msg, $xcode, $sofar, $max)
{
    global $term_sol, $severity_map, $max_kb_sec, $size;

    /* Prefiks komunikatu statusu nie bdzie wywietlany,
     * gdy otrzymane zostanie zdarzenie PROGRESS. */
    if ($code != STREAM_NOTIFY_PROGRESS) {
        echo $severity_map[$severity]. ": ";
    }

    switch ($code) {
        case STREAM_NOTIFY_CONNECT:
            printf("Poczony\n");
            /* Ustawienie czasu do oblicze kb/sek */
            $GLOBALS['begin_time'] = time() - 0.001;
            break;

        case STREAM_NOTIFY_AUTH_REQUIRED:
            printf("Wymagane uwierzytelnienie: %s\n", trim($msg));
            break;

        case STREAM_NOTIFY_AUTH_RESULT:
            printf("Zalogowano: %s\n", trim($msg));
            break;

        case STREAM_NOTIFY_MIME_TYPE_IS:
            printf("Typ Mime : %s\n", $msg);
            break;

        case STREAM_NOTIFY_FILE_SIZE_IS:
            printf("Pobieranie %d kb\n", $max / 1024);
            /* Ustawienie globalnej zmiennej wskazujcej rozmiar */
            $size = $max;
            break;

        case STREAM_NOTIFY_REDIRECTED:
            printf("Przekierowanie do %s...\n", $msg);
            break;

        case STREAM_NOTIFY_PROGRESS:
            /* Obliczenie liczby gwiazdek i linii */
            if ($size) {
                $stars = str_repeat ('*', $c = $sofar * 50 / $size);
            } else {
                $stars = '';
            }
            $stripe = str_repeat ('-', 50 - strlen($stars));

            /* Obliczenie prdkoci pobierania w kb/sek */
            $kb_sec = ($sofar / (time() - $GLOBALS['begin_time'])) / 1024;

            /* Wstrzymanie skryptu, jeli przekroczona zostaa maksymalna prdko pobierania */
            while ($kb_sec > $max_kb_sec) {
                usleep(1);
                $kb_sec = ($sofar / (time() - $GLOBALS['begin_time'])) / 1024;
            }

            /* Wywietlenie paska postpu */
            printf("{$term_sol}[%s] %d kb %.1f kb/sek",
                $stars.$stripe, $sofar / 1024, $kb_sec);
            break;

        case STREAM_NOTIFY_FAILURE:
            printf("Niepowodzenie: %s\n", $msg);
            break;
    }
}

/* Ustalenie nazwy pliku, do ktrego nastpi zapis */
$url_data = parse_url($argv[1]);
$file = basename($url_data['path']);
if (empty($file)) {
    $file = "index.html";
}
printf ("Zapisywanie do pliku $file.gz\n");
$fil = "compress.zlib://$file.gz";

/* Utworzenie kontekstu i ustawienie powiadamiajcej funkcji zwrotnej */
$context = stream_context_create();
stream_context_set_params($context, array ("notification" => "notifier"));

/* Otwarcie docelowego adresu URL */
$fp = fopen($url, "rb", false, $context);
if (is_resource($fp)) {
    /* Otwarcie pliku lokalnego */
    $fs = fopen($fil, "wb9", false, $context);
    if (is_resource($fs)) {
        /* Odczytanie danych z URL-a w blokach 1024-bajtowych */
        while (!feof($fp)) {
            $data = fgets($fp, 1024);
            fwrite($fs, $data);
        }
        /* Zamknicie pliku lokalnego */
        fclose($fs);
    }
    /* Zamknicie pliku zdalnego */
    fclose($fp);

    /* Wywietlenie informacji o pobraniu */
    printf("{$term_sol}[%s] Czas pobierania: %ds\n",
        str_repeat('*', 50), time() - $GLOBALS['begin_time']);
}
?>
