<?php
    /* Zainicjowanie zmiennych */  
    $level = 0;
    $char_data = '';

    /* Utworzenie uchwytu parsera */
    $xml = xml_parser_create('UTF-8');

    /* Ustawienie uchwytw */
    xml_set_element_handler ($xml, 'start_handler', 'end_handler');
    xml_set_character_data_handler ($xml, 'character_handler');

    /* Pocztek parsowania caego pliku naraz */
    xml_parse($xml, file_get_contents('test2.xml'));

    /**************************************************************
     * Funkcje
     */

    /*
     * Pobiera zebrane dane z uchwytu danych
     */
    function flush_data ()
    {
        global $level, $char_data;
        /* Usunicie znakw spacji i zwrcenie danych, jeli jakie pozostan */
        $char_data = trim($char_data);
        if (strlen($char_data) > 0) {
            echo "\n";
            // Zawinicie wierszy, by mieciy si na ekranie terminala
            $data = split("\n", wordwrap($char_data, 76-($level * 2)));
            foreach ($data as $line) {
                echo str_repeat('  ', ($level + 1))."[".$line."]\n";
            }
        }
        /* Wyczyszczenie bufora z danych */
        $char_data = '';
    }

    /*
     * Uchwyt dla znacznikw pocztkowych
     */
    function start_handler ($xml, $tag, $attributes)
    {
        global $level;

        /* Pobranie zebranych danych z uchwytu danych */
        flush_data();
        /* Zrzucenie atrybutw w postaci acucha znakw */
        echo "\n".str_repeat('  ', $level)."$tag";
        foreach ($attributes as $key => $value) {
            echo " $key='$value'";
        }
        /* Zwikszenie gbokoci wcicia */
        $level++;
    }

    function end_handler ($xml, $tag)
    {
        global $level;

        /* Pobranie zebranych danych z uchwytu danych */
        flush_data();
        /* Zmniejszenie gbokoci wcicia i wywietlenie znacznika kocowego */
        $level--;
        echo "\n".str_repeat('  ',$level)."/$tag";
    }

    function character_handler ($xml, $data)
    {
        global $level, $char_data;

        /* Dodanie danych znakowych do bufora */
        $char_data .= ' '.$data;
    }
?>
