<?php
    $db = new SQLiteDatabase("./crm.db", 0666, &$error)
        or die("Niepowodzenie: $error");

    function normalize($body)
    {
       $body = strtolower($body);
       $body = preg_replace(
           '/[.;,:!??!\[\]@\(\)]/', ' ', $body);
       $body = preg_replace('/[^a-z0-9 -]/', '_', $body);

       return $body;
    }

    function index_document($id, $title, $intro, $body)
    {
       global $db;
       $id = $db->singleQuery("SELECT max(id) FROM document");
       $body = substr($body, 0, 32000);
       $body = normalize($body);
       $words = preg_split(
           '@([\W]+)@', $body, -1,
           PREG_SPLIT_OFFSET_CAPTURE |
           PREG_SPLIT_NO_EMPTY
       );
       foreach ($words as $word) {
           $safe_word = sqlite_escape_string($word[0]);

           if ((strpos($safe_word, '_') === false) &&
               (strlen($safe_word) < 24))
           {
              $result = @$db->query(
                 "INSERT INTO dictionary(word) ".
                 "VALUES('$safe_word');");
              if ($result != SQLITE_OK) {
                  /* ju istnieje, trzeba wtedy pobra numer ID */
                  $word_id = $db->singleQuery(
                     "SELECT id FROM dictionary ".
                     "WHERE word = '$safe_word'");
              } else {
                  $word_id = $db->lastInsertRowID();
              }

              $db->query(
                  "INSERT INTO ".
                  "lookup(document_id, word_id, position) ".
                  "VALUES($id, $word_id, {$word[1]})");
            }
        }
    }

    if ($argc <2) {
        echo "Uycie:\n\tphp insert.php <nazwa_pliku>\n\n";
        return; 
    }
    
    $db->createFunction("php_index", "index_document", 4);  

    $body = file_get_contents($argv[1]);
    $mails = preg_split('/^From /m', $body);
    unset($body);
    // $db->query("BEGIN");
    foreach ($mails as $id => $mail) {
        $safe_mail = sqlite_escape_string($mail);
        $insert_query = "
INSERT INTO document(title, intro, body)
VALUES ('Tytu', 'To jest intro.','{$safe_mail}')
";
        echo "Indeksowanie poczty #$id.\n";
        $db->query($insert_query);
    }
    // $db->query("COMMIT);

?>
