<?php
function sanitize_vars(&$vars, $signatures, $redir_url = null)
{
    $tmp = array();
    /* Przejd przez sygnatury i dodaj je do tymczasowej tablicy $tmp */
    foreach ($signatures as $name => $sig) {
        if ((!isset($vars[$name])) &&
            isset ($sig['required']) && $sig['required'])
        {
            /* przekieruj, jeli zmienna nie istnieje w tablicy */
            if ($redir_url) {
                header("Location: $redir_url");
            } else {
                echo 'Brak parametru $name lub brak przekierowujcego adresu URL'; 
            }
            exit();
        }

        /* zastosuj typ do zmiennej */
        $tmp[$name] = $vars[$name];
        if (isset($sig['type'])) {
            settype($tmp[$name], $sig['type']);
        }
        /* zastosuj funkcje do zmiennych; mona uywa standardowe funkcje PHP
         * lub wasne, aby zwikszy elastyczno. */
        if (isset($sig['function'])) {
            $tmp[$name] = $sig['function']($tmp[$name]);
        }
    }
    $vars = $tmp;
}

$sigs = array(
    'prod_id' => array('required' => true, 'type' => 'int'),
    'desc' => array('required' => true, 'type' => 'string', 'function' => 'addslashes')
);

sanitize_vars (&$_GET, $sigs,
    "http:// {$_SERVER['SERVER_NAME']}/error.php?cause=vars");
?>
