<?php

class ClassOne {
    function callClassOne() {
        print "W klasie One\n";
    }
}

class ClassTwo {
    function callClassTwo() {
        print "W klasie Two\n";
    }
}

class ClassOneDelegator {
    private $targets;

    function __construct() {
        $this->targets[] = new ClassOne();
    }

    function addObject($obj) {
        $this->targets[] = $obj;
    }

    function __call($name, $args) {
        foreach ($this->targets as $obj) {
            $r = new ReflectionClass($obj);

            try {
                if ($method = $r->getMethod($name)) {
                        if ($method->isPublic() && !$method->isAbstract()) {
                            return $method->invoke($obj, $args);
                        }
                    }
                } catch (ReflectionException $e) {
            }
        }
    }
}

$obj = new ClassOneDelegator();
$obj->addObject(new ClassTwo());
$obj->callClassOne();
$obj->callClassTwo();

?>
