<?php

require_once "Cache/Lite/Output.php";

$time_s = utime();

if (empty($_GET['id'])) {
    die("prosz poda identyfikator artykuu!");
}

$cache = new Cache_Lite_Output(
    array('lifeTime' => 300, // 5 minut
          'cacheDir' => '/tmp/bufor_artykuly/'));

if ($cache->start($_GET['id'], 'article')) {
    $cached = true;
} else {
    include_once "DB.php";
    include_once "HTML/Template/Flexy.php";

    $dbh = DB::connect("mysql://test@localhost/test");
    $article = $dbh->getRow(
        "SELECT * FROM articles WHERE id = ?",
        array($_GET['id']), DB_FETCHMODE_OBJECT);
    $dir = dirname(__FILE__);
    $tpl = new HTML_Template_Flexy(
        array('templateDir' => "$dir/szablony",
              'compileDir' => "$dir/szablony/skompilowane",
              'filters' => 'Php,SimpleTags,BodyOnly'));
    $tpl->compile('flexy_wyswietl_artykul.tpl');
    $tpl->outputObject($article);

    $cache->end();
    $cached = false;
}

$elapsed = utime() - $time_s;
printf("<div style=\"font-size:x-small\">".
       "(spent %.1fms %s)</div>\n", $elapsed * 1000,
       $cached ? "udostpnienie strony z bufora" : "generowanie strony");
 
function utime() {
    list($usec, $sec) = explode(" ", microtime());
    return (double)$usec + $sec;
}

?>