<?php
    $dom = new DomDocument();

    $html = $dom->createElement('html');
    $html->setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
    $html->setAttribute("xml:lang", "en");
    $html->setAttribute("lang", "en");
    $dom->appendChild($html);

/* Najpierw tworzona jest klasa DomDocument przy uyciu domxml_new_doc().
 * Przekazywany parametr wskazuje wersj XML, ktra zostanie zastosowana w tym dokumencie.
 * Zawsze ma on warto "1.0". Wszystkie elementy s tworzone przez metod createElement()
 * klasy Document. Parametrem tej metody jest nazwa elementu - w tym przypadku jest to 'html'.
 * Wartoci zwracan jest obiekt typu DomElement, za pomoc ktrego do elementu mona dodawa
 * atrybuty. Po penym zdefiniowaniu DomElement dodajemy go do DomDocument wywoujc metod
 *  appendChild(). W dalszej kolejnoci dodawany jest nagwek elementu html oraz tytu do
 * elementu nagwka head: */

    $head = $dom->createElement('head');
    $html->appendChild($head);

    $title = $dom->createElement('title');
    $title->appendChild($dom->createTextNode("Przykladowy XML"));
    $head->appendChild($title);

/* Ponownie najpierw tworzony jest obiekt DomElement przez wywoanie metody createElement()
 * obiektu DomDocument, po czym jest on dodawany do obiektu DomElement $hmtl przy uyciu
 * appendChild(). Nastpnie do elementu body dodawany jest atrybut "background" oraz element p
 * bdcy potomkiem elementu body, zawierajcy gwn zawarto naszego dokumentu X(HT)ML: */

    /* Utworzenie elementu body */
    $body = $dom->createElement('body');
    $body->setAttribute("background", "bg.png");
    $html->appendChild($body);

    /* Utworzenie elementu p */
    $p = $dom->createElement('p');
    $body->appendChild($p);

/* Zawarto elementu "p" jest bardziej zoona. Zawiera on (w kolejnoci) element tekstowy
 * ("Przeniesione do "), element "a", kolejny element tekstowy (kropka), element "br"
 * i w kocu kolejny element tekstowy ("raz & dwa"): */

    /* Dodanie "Przeniesione do " */
    $text = $dom->createTextNode("Przeniesione do ");
    $p->appendChild($text);

    /* Dodanie elementu a */
    $a = $dom->createElement('a');
    $a->setAttribute("href", "http://przyklad.org/");
    $a->appendChild($dom->createTextNode("przyklad.org"));
    $p->appendChild($a);

    /* Dodanie ".", br i "raz & dwa" */
    $text = $dom->createTextNode(".");
    $p->appendChild($text);

    $br = $dom->createElement('br');
    $p->appendChild($br);

    $text = $dom->createTextNode("raz & dwa");
    $p->appendChild($text);

/* Po utworzeniu obiektu DOM naszego dokumentu X(HT)ML wywietlamy go na ekranie. */

    echo $dom->saveXml();
?>
