#!/usr/bin/php
<?php
require_once "Console/Getopt.php";

$verbose = 1;
$config_file = $_ENV['HOME']. '/.myrc';
$options = Console_Getopt::getopt($argv, 'hqvc::',
                                  array('help', 'quiet', 'verbose', 'config='));
foreach ($options[0] as $opt) {
    var_dump($opt) ;
    switch ($opt[0]) {
        case 'q': case '--quiet':
            $verbose--;
            break;
        case 'v': case '--verbose':
            $verbose++;
            break;
        case 'h': case '--help':
            usage();
            exit;
        case 'c'; case '--config':
            $config_file = $opt[1];
            break;
    }
}
if ($verbose > 1) {
      print "Plik konfiguracyjny znajduje si w \"$config_file\".\n";
}

// pozostaa cz kodu skryptu

function usage() {
    $stderr = fopen("php://stderr", "w");
    $progname = basename($GLOBALS['argv'][0]);
    fwrite($stderr, "Zastosowanie: $progname [options]
    Opcje:
        -q, --quiet                 mniej opisw
        -v, --verbose               wicej opisw
        -h, --help                  wywietlenie pomocy
        -c <plik>, --config=<plik>  odczytanie konfiguracji z pliku <plik>
    ");
        fclose($stderr);
}
?>
