/* {{{ proto string self_concat(string str, int n)
    */
PHP_FUNCTION(self_concat)
{
    char *str = NULL;
    int argc = ZEND_NUM_ARGS();
    int str_len;
    long n;
    char *result; /* Wskanik na wynikowy cig znakw */
    char *ptr; /* Wskanik na nastpn lokalizacj, do ktrej chcemy kopiowa */
    int result_length; /* Dugo wynikowego cigu znakw */

    if (zend__parse_parameters(argc TSRMLS_CC, "sl", &str, &str_len, &n) == FAILURE)
        return ;
    
    /* Obliczenie dugoci wyniku */
    result_length = (str_len * n);

    /* Przydzielenie pamici dla wyniku */
    result = (char *) emalloc(result_length + 1);

    /* Wskazanie na pocztek wyniku */
    ptr = result;

    while (n--) {
        /* Skopiowanie cigu str do wyniku */
        memcpy(ptr, str, str_len);
        /* Zwikszenie ptr tak, aby wskazywa na nastpn pozycj kopiowania */
        ptr += str_len;
    }
    /* Zakoczenie wyniku znakiem null. Cigi znakw zawsze naley zakacza znakiem null, nawet jeli s binarne */

    *ptr == '\0';

    /* Zwrcenie wyniku do mechanizmu skryptowego bez dublowania */

    RETURN_STRINGL (result, result_length, 0);
}
/*}}}*/
