<?php
  require_once "XML/RSS.php";
  $cache_file = "/tmp/php.net.rss";

/* Najpierw woczana jest klasa PEAR oraz wskazywana jest lokalizacja pliku bufora.
 * */

  if (!file_exists($cache_file) ||
      (filemtime($cache_file) < time() - 86400))
  {
      copy("http://www.php.net/news.rss", $cache_file);
  }

/* Nastpnie sprawdzamy, czy plik by ju wczeniej buforowany i czy nie jest zbyt stary.
 * (86400 sekund to jeden dzie). Jeeli plik nie istnieje lub jest zbyt stary,
 * pobierana jest nowa zawarto z php.net i zapisywana w pliku bufora. */

  $r =& new XML_RSS($cache_file);
  $r->parse();

/* Tworzony jest egzemplarz klasy XML_RSS z plikiem RSS jako parametrem oraz wywoywana jest
 * metoda parse(). Parsuje ona plik RSS do struktury, ktr mona odczyta dwiema metodami:
 * getChannelInfo(), aby zwrci tytu, opis i cze do witryny w postaci tablicy:

array(3) {
  ["title"]=>
  string(27) "PHP: Hypertext Preprocessor"
  ["link"]=>
  string(19) "http://www.php.net/"
  ["description"]=>
  string(35) "The PHP scripting language web site"
}

 * oraz getItems(), aby zwrci tytu, opis i cze do wiadomoci.
 * Uywamy tej drugiej metody, aby w ptli przej przez wszystkie wiadomoci i je wywietli: */

  foreach ($r->getItems() as $value) {
      echo strtoupper($value['title']). "\n";
	  echo wordwrap($value['description']). "\n";
	  echo "\t{$value['link']}\n\n";
  }
?>
