<?php
    require("XML/RPC.php");
    require("PEAR.php");

    $client = new XML_RPC_Client('/rozdzial_08/xmlrpc_przyklad.php', 'localhost');

    function call_method ($client, $msg) {
        $p = $client->send($msg);        
        if (PEAR::isError($p)) {
            echo $p->getMessage();
        } else {
            if ($p->faultCode()) {
                echo $p->faultString();
                    return NULL;
            } else {
                $res = $p->value();
                return $res;
            }
        }
    }

    /* Prosty przykad z typem niejawnym */
    $vals = array (
        new XML_RPC_Value('Daniel', 'string')
    );
    $msg = new XML_RPC_Message('hello', $vals);
    $res = call_method(&$client, &$msg);
    if ($res !== NULL) {
        echo XML_RPC_decode($res)."\n";
    }


    /* Kolejny przykad - z typami jawnymi i wieloma parametrami */
    $vals = array (
        XML_RPC_encode(97.0),
        XML_RPC_encode(80.9),
    );
    $msg = new XML_RPC_Message('add', $vals);
    $res = call_method(&$client, &$msg);
    echo XML_RPC_decode($res)."\n";


    /* Zoony przykad ilustrujcy retrospekcj */
    $msg = new XML_RPC_Message('system.listMethods');
    $res = call_method($client, $msg);

    foreach (XML_RPC_decode($res) as $item) {

        $vals = array (XML_RPC_encode($item));
        $msg = new XML_RPC_Message('system.methodHelp', $vals);
        $desc = XML_RPC_decode(call_method($client, $msg));

        $msg = new XML_RPC_Message('system.methodSignature', $vals);
        $sigs = XML_RPC_decode(call_method($client, $msg));
        $siginfo = '';
        foreach ($sigs[0] as $sig) {
            $siginfo .= $sig. " ";
        }

        echo "$item\n". wordwrap($desc). "\n\t$siginfo\n\n";
    }

?>
