<?php
    $db = new SQLiteDatabase("./crm.db", 0666, &$error)
        or die ("Niepowodzenie: $error");
 
    $create_query = "
CREATE TABLE document (
    id INTEGER PRIMARY KEY,
    title,
    intro,
    body
);

CREATE TABLE dictionary (
    id INTEGER PRIMARY KEY,
    word
);

CREATE TABLE lookup (
    document_id INTEGER,
    word_id INTEGER,
    position INTEGER
);

CREATE UNIQUE INDEX word ON dictionary(word);
";

    $db->query($create_query);

    $trigger_query = "
CREATE TRIGGER index_new
AFTER INSERT ON document
BEGIN
SELECT php_index(new.id, new.title, new.intro, new.body);
END;";
    $db->query($trigger_query);

unset($db);
?>


