<?php
    /* ustawienia konfiguracyjne */
    $max_photo_size = 50000;
    $upload_required = true;
    $upload_page = 'index.php';
    $upload_dir = '/home/httpd/html/fileup1/';
    $err_msg = false;
    do {
       /* Czy to pole pliku w ogle istnieje? */
       if (!isset ($_FILES['book_image'])) {
           $err_msg = 'Formularz nie zosta przesany w caoci.';
           break;
       } else {
          $book_image = $_FILES['book_image'];
       }

       /* Sprawdzamy wszystkie moliwe do uzyskania kody bdw */
      switch ($book_image['error']) {
         case UPLOAD_ERR_INI_SIZE:
            $err_msg = 'Rozmiar obrazu jest zbyt duy, '.
               "nie moe przekracza $max_photo_size bajtw.";
            break 2;
         case UPLOAD_ERR_PARTIAL:
            $err_msg = 'Podczas wgrywania pliku wystpi bd, '.
               "prosimy <a href='{$upload_page}'>sprbowa ponownie</ a>.";
            break 2; 
         case UPLOAD_ERR_NO_FILE:
            if ($upload_required) {
             $err_msg = 'Nie wybrano pliku do wgrania, '.
               "prosimy zrobi to <a href='{$upload_page}'>tutaj</ a>.";
             break 2;
            }
            break 2;
         case UPLOAD_ERR_FORM_SIZE:
            $err_msg = 'Zbyt duy rozmiar wedug '.
               'ukrytego pola MAX_FILE_SIZE w formularzu wysyania.';
         case UPLOAD_ERR_OK:
            if ($book_image['size'] > $max_photo_size) {
               $err_msg = 'Rozmiar obrazu jest zbyt duy, '.
               'nie moe przekracza $max_photo_size bajtw.';
            }
            break 2;

         default:
            $err_msg = 'Wystpi nieznany bd, '.
                "prosimy sprbowa ponownie <a href='{$upload_page}'>tutaj</ a>.";
         }
      /* Sprawdzamuy poprawnoc typu mime, dopuszczamy obrazy JPEG i PNG */
      if (!in_array(
          $book_image['type'],
          array ('image/jpeg', 'image/pjpeg', 'image/png')
      )) {
          $err_msg = 'Naley wgrywa obrazy PNG lub JPEG, '.
             "zapraszamy do zrobienia tego<a href='{$upload_page}'>tutaj</ a>.";
          break;
      }
   } while (0);

   /* Jeli nie wystpi aden bd, plik zostaje przeniesiony do katalogu wgranych       plikw */
   if (!$err_msg) {
      if (!@move_uploaded_file(
          $book_image['tmp_name'],
          $upload_dir . $book_image['name']
       )) {
          $err_msg = "Bd przy przenoszeniu pliku do jego miejsca docelowego, ".
             "prosimy sprbowa ponownie <a href='{$upload_page}'>tutaj</a>.";
      }
   }
?>

<html>
<head><title>Obsuga wgrywania</title>
<body>
<?php
    if ($err_msg) {
    echo $err_msg;
    } else {
?>
<img scr='<?php echo $book_image['name']; ?>'/>
<?php
    }
?>
</body>
</html>






