<?php

class Crypt_HMAC {

    /**
     * Konstruktor
     * Przekazuje metod jako pierwszy parametr
     *
     * @param string method - Funkcja mieszajca uywana do oblicze
     * @return void
     * @access public
     */
    function Crypt_HMAC($key, $method = 'md5')
    {
        if (!in_array($method, array('sha1', 'md5'))) {
            die("Nieobsugiwana funkcja mieszajca '$method'.");
        }
        $this->_func = $method;

        /* Dopenij klucz zgodnie z zaleceniami RFC (punkt 1) */
            if (strlen($key) > 64) {
        $key = pack('H32', $method($key));
        }

        if (strlen($key) < 64) {
            $key = str_pad($key, 64, chr(0));
        }

        /* Oblicz uzupenione klucze i zapisz je (punkt 2 i 3) */
        $this->_ipad = substr($key, 0, 64) ^ str_repeat(chr(0x36), 64);
        $this->_opad = substr($key, 0, 64) ^ str_repeat(chr(0x5c), 64);
}
/**
     * Funkcja mieszajca
     *
     * @param string data - acuch, ktry zostanie poddany mieszaniu (punkt 4)
     * @return string
     * @access public
     */
    function hash($data)
    {
        $func = $this->_func;
        $inner = pack('H32', $func($this->_ipad . $data));
        $digest = $func($this->_opad . $inner);

        return $digest;
    }
}
?>


