<?php

abstract class User {
    function __construct($name) 
    {
        $this->name = $name;
    }

    function getName() 
    {
        return $this->name;
    }

    // Metody uprawnie
    function hasReadPermission() 
    {
        return true;
    }

    function hasModifyPermission()
    {
        return false;
    }

    function hasDeletePermission()
    {
        return false;
    }

    // Metody dostosowania do potrzeb
    function wantsFlashInterface()
    {
        return true;
    }

    protected $name = NULL;
}

class GuestUser extends User {
}

class CustomerUser extends User {
    function hasModifyPermission()
    {
        return true;
    }
}

class AdminUser extends User {
    function hasModifyPermission()
    {
        return true;
    }

    function hasDeletePermission()
    {
        return true;
    }

    function wantsFlashInterface()
    {
        return false;
    }
}

class UserFactory {
    private static $users = array("Andrzej"=>"admin", "Stefan"=>"guest",
                            "Darek"=>"customer");

    static function Create($name)
    {
        if (!isset(self::$users[$name])) {
            // Bd poniewa uytkownik nie istnieje
        }
        switch (self::$users[$name]) {
            case "guest": return new GuestUser($name);
            case "customer": return new CustomerUser($name);
            case "admin": return new AdminUser($name);
            default: // Bd poniewa ten rodzaj uytkownika nie istnieje
        }
    }
}

function boolToStr($b)
{
    if ($b == true) {
        return "Tak\n";
    } else {
        return "Nie\n";
    }
}

function displayPermissions(User $obj)
{
    print $obj->getName() . "- uprawnienia\n ";
    print "Do odczytu: " . boolToStr($obj->hasReadPermission());
    print "Do modyfikacji: " . boolToStr($obj->hasModifyPermission());
    print "Do usuwania: " . boolToStr($obj->hasDeletePermission());
}

function displayRequirements(User $obj)
{
    if ($obj->wantsFlashInterface()) {
        print $obj->getName() . " wymaga Flash\n";
    }
}

$logins = array("Andrzej", "Stefan", "Darek");

foreach($logins as $login) {
    displayPermissions(UserFactory::Create($login)); 
    displayRequirements(UserFactory::Create($login));
}

?>
