<?php # Script 13.5 - stores_json.php
require_once('convert.php');
/*  Ten skrypt wysya zapytanie do bazy danych i zwraca
 *  list 10 sklepw wraz z informacjami o odlegoci, jaka dzieli je
 *   od miejscowoci o podanym kodzie pocztowym.
 *  Strona jest wywoywana z poziomu JavaScript.
 *  Nie wymaga kodu HTML!
 */
 
$zip = FALSE; // Zmienna-flaga.

// Sprawdzenie, czy do skryptu przekazano zmienn $_GET['kod']:
if ( isset($_GET['kod']) &&
	( (strlen($_GET['kod']) == 6) )
	) {
	
               // Obcicie ostatnich cyfr, jeli jest taka konieczno.
	if (strlen($_GET['kod']) > 6) {
		$zip = substr($_GET['kod'], 0, 6);
	} else {
		$zip = $_GET['kod'];
	}
	
                // Sprawdzenie, czy kod pocztowy jest liczb:
 	if (preg_match('/\d{2}-\d{3}/', $_GET['kod'])) {

                // Nawizanie poczenia z baz danych.
                $dbc = @mysqli_connect ('localhost', 'root', '', 'kody') OR die ('null');
                // W celu wyeliminowania problemw z wywietlaniem polskich znakw
                mysqli_query($dbc,'SET CHARACTER cp1250'); 
                mysqli_query($dbc,'SET NAMES cp1250');	 
	                mysqli_query($dbc,'SET CHARACTER_SET cp1250');
		
                                // Odczytanie dugoci i szerokoci geograficznej punktu pocztkowego:
  	               $q = "SELECT szer_geogr, dlug_geogr FROM kody_pocztowe WHERE kod_pocztowy='$zip';";
                               	$r = mysqli_query($dbc, $q);
		
                               // Odczytanie wynikw:
		if (mysqli_num_rows($r) == 1) {
		
			list($lat, $long) = mysqli_fetch_array($r, MYSQLI_NUM);

		} else { // Nieprawidowy kod pocztowy.
			$zip = FALSE;
			mysqli_close($dbc);
		}

	} else { // Nieprawidowy kod pocztowy.
		$zip = FALSE;
	}
	
}

if ($zip) { // Pobranie informacji o sklepach i odlegociach.

	// Rozbudowane, wane zapytanie:
 
	$q = "SELECT nazwa, CONCAT_WS('<br />', adres_1, adres_2), miasto, powiat, s.kod_pocztowy, telefon, round(oblicz_odleglosc($lat, $long, szer_geogr, dlug_geogr)) AS odleglosc FROM sklepy AS s LEFT JOIN kody_pocztowe AS z USING (kod_pocztowy) ORDER BY odleglosc ASC LIMIT 5";
 	$r = mysqli_query($dbc, $q);
	
	if (mysqli_num_rows($r) > 0) {
	
		// Zainicjowanie tablicy:
		$json = array();
		
		// Umieszczenie w tablicy danych o kadym ze sklepw:
		while (list($name, $address, $city, $state, $zip, $phone, $distance) = mysqli_fetch_array($r, MYSQLI_NUM)) {
		
			$json[] = array('nazwa' => cnv($name),
			'adres' => cnv($address), 
			'miasto' => cnv(ucfirst(strtolower($city))), 
			'powiat' => cnv($state), 
			'kod_pocztowy' => cnv($zip), 
			'telefon' => cnv($phone), 
			'odleglosc' => cnv($distance));
				
		}
		
		// Wysanie danych w formacie JSON:

		echo json_encode($json) . "\n";
                                
		
	} else { // Skrypt nie zwrci wynikw.
		echo 'null';
	}

	mysqli_close($dbc);
	
} else { // Nieprawidowy kod pocztowy.
	echo 'null';
}
?>