// Skrypt 13.6 - stores.js

/*   Ten skrypt wykonuje ca magi zastosowania
 *  technologii Ajax do formularza pobierajcego dane sklepw.
 *   Wprowadzony kod pocztowy jest przesyany do skryptu PHP,
 *  ktry nastpnie zwraca dane w formacie JSON.
 */

// Funkcja rozpoczynajca proces Ajax:
function get_stores(zip) {
   if (ajax) {

        // Wywoanie skryptu PHP.
        // Wykorzystano metod GET.
        // Kod pocztowy  przekazano w adresie URL.
       ajax.open('get', 'stores_json.php?kod=' + encodeURIComponent(zip));

        // Funkcja obsugujca odpowied:
       ajax.onreadystatechange = handle_stores;

        // Wysanie dania:
        ajax.send(null);

       return false;

   } else { // Nie mona uy Ajax!
       return true;
   }

} // Koniec funkcji get_stores().

// Funkcja obsugujca odpowied od skryptu PHP:
function handle_stores() {

    // Jeli jest wszystko w porzdku:
    if ( (ajax.readyState == 4) && (ajax.status == 200) ) {

       // Sprawdzenie dugoci odpowiedzi:
       if (ajax.responseText.length > 10) {

          // Wysanie odpowiedzi w postaci obiektowej
          // do funkcji show_stores():
          show_stores(eval('(' + ajax.responseText + ')'));

       } else {
           document.getElementById('list').innerHTML = '<p>aden sklep nie spenia kryteriw wyszukiwania.</p>';
       }

  }

} // Koniec funkcji handle_stores().

// Funkcja wywietlajca list sklepw:
function show_stores(stores) {

    // Zainicjowanie cigu znakw:
    var message = '';

    // Pobranie danych poszczeglnych sklepw:
    for (var i = 0 ; i < stores.length ; i++) {

        // Dodanie do cigu znakw:
        message += '<h2>' + stores[i].nazwa + '</h2>'
        + '<p>' +  stores[i].adres + '<br />'
        + stores[i].miasto + ', ' + stores[i].powiat + ' '
        + stores[i].kod_pocztowy + '<br />'
        + stores[i].telefon + '<br />(w przyblieniu '
        + stores[i].odleglosc + ' kilometrw)</p>';
    }

    // Umieszczenie cigu na stronie:
    document.getElementById('list').innerHTML = message;

  } // Koniec funkcji show_stores().
