<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//PL"
       "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="pl">
<head>
    <meta http-equiv="content-type" content="text/html; charset=windows-1250" />
    <title>Test szybkoci dziaania kodu</title>
 </head>
<body>
<?php # Skrypt 12.1 - timer.php

/*  Ten skrypt wykonuje test szybkoci dziaania trzech
 *  rnych typw instrukcji echo().
 *  Skrypt wymaga zainstalowania pakietu PEAR Benchmark.
 */

// Przykadowe dane do wywietlenia:
$data = 'To jest przykadowy tekst.';

// Zaadowanie definicji klasy Timer:
require ('Benchmark/Timer.php');

// Utworzenie i uruchomienie licznika czasu:
$timer = new Benchmark_Timer();
$timer->start();

// Pomiar szybkoci dziaania wersji z apostrofami:
$timer->setMarker('echo1');
echo '<h1>Instrukcja echo() z apostrofami</h1>
<table border="0" width="90%" cellspacing="3" cellpadding="3" align="center">
    <tr>
        <td>' . $data . '</td>
        <td>' . $data . '</td>
        <td>' . $data . '</td>
    </tr>
    <tr>
        <td>' . $data . '</td>
        <td>' . $data . '</td>
        <td>' . $data . '</td>
    </tr>
  </table>
<p>Koniec testu dla instrukcji echo() z apostrofami.</p>
';

// Pomiar szybkoci dziaania wersji z cudzysowami:
$timer->setMarker('echo2');
echo "<h1>Instrukcja echo() z cudzysowami</h1>
<table border=\"0\" width=\"90%\"  cellspacing=\"3\" cellpadding=\"3\"  align=\"center\">
    <tr>
        <td>$data</td>
        <td>$data</td>
        <td>$data</td>
    </tr>
    <tr>
        <td>$data</td>
        <td>$data</td>
        <td>$data</td>
    </tr>
  </table>
<p>Koniec testu dla instrukcji echo() z cudzysowami.</p>";

// Pomiar szybkoci dziaania wersji z wykorzystaniem skadni heredoc:
$timer->setMarker('heredoc');
echo <<<EOT
<h1>Skadnia heredoc</h1>
<table border="0" width="90%" cellspacing="3" cellpadding="3" align="center">
    <tr>
        <td>$data</td>
        <td>$data</td>
        <td>$data</td>
    </tr>
    <tr>
        <td>$data</td>
        <td>$data</td>
        <td>$data</td>
    </tr>
  </table>
<p>Koniec testu dla skadni heredoc.</p>
EOT;

// Ustawienie kocowego znacznika i zatrzymanie licznika czasu:
$timer->setMarker('koniec');
$timer->stop();

   // Wywietlenie wynikw:
echo '<hr/><h1>Wyniki:</h1>';

echo '<p>Czas wymagany do wykonania instrukcji echo() z apostrofami: ' . $timer->timeElapsed('echo1', 'echo2') . '</p>';

echo '<p>Czas wymagany do wykonania instrukcji echo() z cudzysowami: ' . $timer->timeElapsed('echo2', 'heredoc') . '</p>';

echo '<p>Czas wymagany do wykonania instrukcji echo() z tekstem zgodnym ze skadni heredoc: ' . $timer->timeElapsed('heredoc', 'koniec'). '</p>';

 // Usunicie obiektu:
unset($timer);
?>
</body>
</html>
