<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//PL"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="pl" lang="pl">
<head>
    <meta http-equiv="content-type" content="text/html; charset=windows-1250" />
    <title>QuickForm</title>
 </head>
<body>
<?php # Skrypt 12.5 - quickform.php

 /* Ten skrypt tworzy formularz rejestracyjny,
 *  Skrypt wymaga zainstalowania pakietu PEAR HTML_QuickForm.
 * To jest ostateczna wersja skryptu.
 */

// Zaadowanie definicji klasy:
require_once ('HTML/QuickForm.php');

// Utworzenie obiektu formularza:
$form = new HTML_QuickForm();

// Dodanie nagwka:
$form->addElement('header', NULL, 'Formularz rejestracyjny');
// Pytanie o nazwisko i imi osoby:
$form->addElement('select', 'tytul', 'Tytu: ', array(
   'Pan' => 'Pan',
   'Pani' => 'Pani',
   'Panna' => 'Panna',
   'Dr' => 'Dr')
);
$form->addElement('text', 'imie', 'Imi: ');
$form->addElement('text', 'nazwisko', 'Nazwisko: ');

// Wywietlenie pytania o adres e-mail:
$form->addElement('text', 'email', 'Adres email: ', array('size' => 30, 'maxlength' => 100));

// Wywietlenie pytania o haso:
$form->addElement('password', 'haslo1', 'Haso: ');
$form->addElement('password', 'haslo2', 'Potwierd haso: ');

// Dodanie przycisku do przesyania formularza:
$form->addElement('submit', 'przeslij', 'Zarejestruj si!');

// Zastosowanie filtra:
$form->applyFilter('__ALL__', 'trim');

// Dodanie regu:
$form->addRule('nazwisko', 'Podaj nazwisko.', 'required', NULL, 'client');
$form->addRule('imie', 'Podaj imi.', 'required', NULL, 'client');
$form->addRule('email', 'Podaj adres email.', 'required', NULL, 'client');
$form->addRule('nazwisko', 'Podaj haso.', 'required', NULL, 'client');
$form->addRule(array('haslo1', 'haslo2'), 'Upewnij si, czy obie wersje hasa s takie same.', 'compare', NULL, 'client');

 // Wywietlenie lub obsuga formularza:
if ($form->validate()) { // Obsuga

    // Wywietlenie odebranych danych:
    echo '<h1>Odebrano nastpujce informacje:</h1>';
    $data = $form->exportValues();
    foreach ($data as $k => $v) {
    echo "<p><em>$k</em> $v</p>\n";
    }

} else { // Wywietlenie formularza
    $form->display();
}

 // Usunicie obiektu:
unset($form);
?>
</body>
</html>
