<?php # Skrypt 10.3 - calculator.php

/*   W tym skrypcie wykorzystano pakiet GTK do stworzenia
 *   graficznego kalkulatora.
 */

// Upewnij si, e zaadowano modu GTK:
if (!class_exists('gtk')) die('Nie zaadowano moduu PHP-Gtk2!');

// Funkcja zerujca kalkulator:
function clear () {

    // Inicjowanie zmiennych:
    global $n1, $n2, $operator;
    $n1 = false;
    $n2 = false;
    $operator = false;

    // Wyzerowanie wywietlacza:
    set_display ();

} // Koniec funkcji clear().

// Funkcja wywietlajca warto w 'oknie' kalkulatora:
function set_display ($value = 0) {
    global $display;
    $display->set_text ($value);
} // Koniec funkcji set_display().

// Funkcja calculate() wykonuje waciwe obliczenia:
function calculate () {

    global $n1, $n2, $operator;

    // Ustawienie wartoci pocztkowej  na wszelki wypadek:
    $value = $n1;

    // Wybr dziaania matematycznego.
    switch ($operator) {
        case 'add':
            $value = $n1 + $n2;
            break;
        case 'subtract':
            $value = $n1 - $n2;
            break;
        case 'multiply':
            $value = $n1 * $n2;
            break;
        case 'divide':
            $value = $n1 / $n2;
            break;
    }

    // Wywietlenie obliczonej wartoci:
    set_display ($value);

    // Zainicjowanie zmiennych:
    $n1 = $value;
    $operator = false;
    $n2 = false;

} // Koniec funkcji calculate().

// Funkcja przypisujca wykorzystywany operator:
function set_operator ($which) {
    global $operator;

    // Jeli ju ustawiono zmienn $operator,
    // wykonanie oblicze z wykorzystaniem biecych wartoci.
    if ($operator) calculate();

    $operator = $which;

} // Koniec funkcji set_operator().

// Funkcja przypisujca wartoci:
function set_number ($value) {

    global $n1, $n2, $operator;

    // Konkatenacja z wartoci $n1 lub $n2:
    if (!$operator) {
        $n1 .= $value;
        set_display($n1);
    } else {
        $n2 .= $value;
        set_display($n2);
    }
}

// *******************
// Koniec definicji funkcji
// *******************

// Definicja gwnych zmiennych:
$n1 = false;
$n2 = false;
$operator = false;

 // Utworzenie nowego okna.
$window = new GtkWindow();
$window->set_title ('Kalkulator');
$window->set_default_size (320, 320);

// Utworzenie innego kontenera:
$box = new GtkVBox();
$window->add($box);

// Utworzenie tabeli:
$table = new GtkTable(5, 6);
$table->set_row_spacings(2);
$table->set_col_spacings(2);
$table->set_border_width(5);

// Umieszczenie tabeli w ramce:
$box->pack_start($table);

// Utworzenie wywietlacza:
$display = new GtkLabel('display');
$table->attach($display, 1, 4, 1, 2);

// Utworzenie przyciskw 0-9.
for ($i = 0; $i <= 9; $i++) {

    // Wyznaczenie wsprzdnych tabeli
    // dla kadej cyfry:
    switch ($i) {
        case 0:
            $x = 1;
            $y = 5;
            break;
        case 1:
            $x = 1;
            $y = 4;
            break;
        case 2:
            $x = 2;
            $y = 4;
            break;
        case 3:
            $x = 3;
            $y = 4;
            break;
        case 4:
            $x = 1;
            $y = 3;
            break;
        case 5:
            $x = 2;
            $y = 3;
            break;
        case 6:
            $x = 3;
            $y = 3;
            break;
        case 7:
            $x = 1;
            $y = 2;
            break;
        case 8:
            $x = 2;
            $y = 2;
            break;
        case 9:
            $x = 3;
            $y = 2;
            break;
    }

    // Utworzenie przycisku dla kadej cyfry:
    $button = new GtkButton($i);
    $button->connect_simple ('clicked', 'set_number', $i);
    $table->attach($button, $x, ($x+1), $y, ($y+1));

} // Koniec ptli FOR dla przyciskw 0-9.


// Umieszczenie pozostaych przyciskw...

// Kropka dziesitna:
$decimal = new GtkButton('.');
$decimal->connect_simple ('clicked', 'set_number', '.');
$table->attach($decimal, 2, 3, 5, 6);

// Znak rwnoci:
$equals = new GtkButton('=');
$equals->connect_simple ('clicked', 'calculate');
$table->attach($equals, 3, 4, 5, 6);

// Klawisz zerowania:
$clear = new GtkButton('C');
$clear->connect_simple ('clicked', 'clear');
$table->attach($clear, 4, 5, 1, 2);

// Znak plus:
$add = new GtkButton('+');
$add->connect_simple ('clicked', 'set_operator', 'add');
$table->attach($add, 4, 5, 2, 3);

// Znak minus:
$subtract = new GtkButton('-');
$subtract->connect_simple ('clicked', 'set_operator', 'subtract');
$table->attach($subtract, 4, 5, 3, 4);

// Znak mnoenia:
$multiply = new GtkButton('*');
$multiply->connect_simple ('clicked', 'set_operator', 'multiply');
$table->attach($multiply, 4, 5, 4, 5);

// Znak dzielenia:
$divide = new GtkButton('/');
$divide->connect_simple ('clicked', 'set_operator', 'divide');
$table->attach($divide, 4, 5, 5, 6);

// Pocztkowe wyzerowanie kalkulatora:
clear();

// Podczenie funkcji quit:
$window->connect_simple ('destroy', array('Gtk', 'main_quit'));

// Wywietlenie wszystkich obiektw:
$window->show_all();

 // Uruchomienie aplikacji:
Gtk::main();
?>
