<?php # Skrypt 8.5 - cart.php

/*
 *   To jest strona obsugujca koszyk na zakupy.
 *   Strona moe dziaa w dwch ttrybach:
 *   - dodawanie towaru do koszyka,
 *   - aktualizacja koszyka
 *   Strona wywietla koszyk w postaci formularza, w ktrym mona aktualizowa iloci.
 *   Koszyk jest obiektem typu WidgetShoppingCart,
 *   zapisanym w sesji.
 */

 // Zaadowanie pliku konfiguracyjnego przed kodem PHP:
 require_once('./include/config.inc.php');

 // Wczenie pliku nagwkowego:
$page_title = 'Koszyk na zakupy';
 include_once ('./include/header.html');

echo '<h1>Zawarto koszyka na zakupy</h1>';

// Utworzenie obiektu koszyka na zakupy:
require_once('WidgetShoppingCart.php');
if (isset($_SESSION['cart'])) {
    $cart = unserialize($_SESSION['cart']);
 } else {
    $cart = new WidgetShoppingCart();
}

// Ta strona dodaje lub aktualizuje 
// koszyk na zakupy na podstawie wartoci zmiennej $_REQUEST['do'];
if (isset($_REQUEST['do']) && ($_REQUEST['do'] == 'dodaj') ) { // Dodanie nowego towaru.
    if (isset($_GET['id_st'])) { // Sprawdzenie identyfikatora produktu.

        // Rzutowanie wartoci na typ integer:
        $sw_id = (int) $_GET['id_st'];

        // Jeli to jest liczba cakowita,
        // pobranie informacji o pozycji:
        if ($sw_id > 0) {

            // Zdefiniowanie i wykonanie zapytania:
            $q = "SELECT nazwa, kolor, rozmiar, domyslna_cena, cena FROM towary_ogolnie LEFT JOIN szczegoly_towarow USING (id_ot) LEFT JOIN kolory USING (id_koloru) LEFT JOIN rozmiary USING (id_rozmiaru)WHERE id_st=$sw_id";
  $r = mysqli_query($dbc, $q);

           if (mysqli_num_rows($r) == 1) {

               // Pobranie wynikw:
                $row = mysqli_fetch_array($r, MYSQLI_ASSOC);

               // Wyznaczenie ceny:
                $price = (empty($row['cena'])) ? $row['domyslna_cena'] : $row['cena'];

                // Dodanie do koszyka.
                $cart->add_item($sw_id, array('nazwa' => $row['nazwa'], 'kolor' => $row['kolor'],'rozmiar' => $row['rozmiar'], 'cena' => $price));

   } // Koniec instrukcji IF mysqli_num_rows().

        } // Koniec instrukcji IF ($sw_id>0).

    } // Koniec instrukcji IF (isset($_GET['id_st']).

} elseif (isset($_REQUEST['do']) && ($_REQUEST['do'] == 'aktualizuj')) {

    // Modyfikacja iloci...
    // $k to identyfikator produktu.
    // $v to nowa ilo.
    foreach ($_POST['qty'] as $k => $v) {

       // Wartoci identyfikatora i iloci musz by liczbami cakowitymi!
       $pid = (int) $k;
       $qty = (int) $v;

       // Aktualizacja koszyka
       $cart->update_item($pid, $qty);

     } // Koniec ptli FOREACH.

   // Wywietlenie komunikatu.
   echo '<p>Koszyk zaktualizowano.</p>';

} // Koniec instrukcji IF-ELSE $_REQUEST.

// Wywietlenie zawartoci koszyka, jeli nie jest pusty.
if (!$cart->is_empty()) {
   $cart->display_cart('cart.php');
        } else {
   echo '<p>Koszyk jest teraz pusty.</p>';

}
// Zapisanie wartoci w sesji:
$_SESSION['cart'] = serialize($cart);

// Wczenie pliku stopki w celu uzupenienia szablonu:
include_once ('./include/footer.html');

?>
