<?php # Skrypt 5.8 - checkout.php

/*
 *  Prosta strona realizacji rozlicze.
 *  W celach demonstracyjnych ta strona jedynie pobiera
 *  i sprawdza poprawno numeru karty kredytowej.
 *  Przyjto zaoenie, e pozostae informacje --
 *  nazwisko, adres, itp.
 *  --bd pobrane z bazy danych po zalogowaniu si uytkownika
 *  i rwnie potwoerdzone na tej stronie.
 */

 // Zaadowanie pliku konfiguracyjnego przed kodem PHP:
 require_once('./include/config.inc.php');

 // Wczenie pliku nagwkowego:
$page_title = 'Rozliczenie';
 include_once ('./include/header.html');

echo '<h1>Rozliczenie</h1>';

// Ustawienie strefy czasowej:
date_default_timezone_set('GMT');

// Sprawdzenie, czy przesano formularz.
if (isset($_POST['przeslano'])) {

    // Sprawdzenie poprawnoci karty kredytowej...

    // Sprawdzenie daty utraty wanoci:
    $year = (int) $_POST['rok_utr_wazn_kk'];
    $month = (int) $_POST['mc_utr_wazn_kk'];

      // Pobranie biecej daty:
    $today = getdate();

    // Sprawdzenie daty utraty wanoci:
    if ( ($year > $today['year']) OR
    ( ($year == $today['year']) AND ($month >= $today['month']) )
    ) {

        // Zaadowanie definicji klasy:
        require ('Validate/Finance/CreditCard.php');

        // Utworzenie obiektu:
        $cc = new Validate_Finance_CreditCard();

        // Sprawdzenie poprawnoci numeru i typu karty kredytowej:
        if ($cc->number($_POST['numer_kk'], $_POST['typ_kk'])) {

            // Uycie cigu XXX w celu przetwarzania zamwienia!!!
            // Jeli test powiedzie si, realizacja zamwienia!
            echo '<p>Zamwienie zostao przyjte (cho tylko na niby).</p>';
            include_once ('./include/footer.html');
            exit();

        } else { // Nieprawidowy numer bd typ karty kredytowej.
            echo '<p class="error">Prosz wprowadzi prawidowy numer i typ karty kredytowej.</p>';
        }

    } else { // Nieprawidowa data.
        echo '<p class="error">Prosz wprowadzi prawidow dat wanoci.</p>';
    }

}

 // Wywietlenie formularza
?>
<form action="checkout.php" method="post">
<input type="hidden" name="przeslano" value="true" />
<table border="0" width="90%" cellspacing="2" cellpadding="2" align="center">
   <tr>
       <td align="right">Typ karty kredytowej:</td>
       <td align="left"><select name="typ_kk">
       <option value="amex">American Express</option>
       <option value="visa">Visa</option>
       <option value="mastercard">MasterCard</option>
       <option value="diners club">Diners Club</option>
       <option value="enroute">enRoute</option>
       </select></td>
   </tr>

   <tr>
       <td align="right">Numer karty kredytowej:</td>
       <td align="left"><input type="text" name="numer_kk" maxlength="20" /></td>
   </tr>

   <tr>
       <td align="right">Data wanoci:</td>
       <td align="left"><select name="mc_utr_wazn_kk">
       <option value="">Miesic</option>
       <option value="1">Sty</option>
       <option value="2">Lut</option>
       <option value="3">Mar</option>
       <option value="4">Kwi</option>
       <option value="5">Maj</option>
       <option value="6">Cze</option>
       <option value="7">Lip</option>
       <option value="8">Sie</option>
       <option value="9">Wrz</option>
       <option value="10">Pa</option>
       <option value="11">Lis</option>
       <option value="12">Gru</option>
       </select> <select name="rok_utr_wazn_kk">
       <option value="">Rok</option>
       <?php for ($start = date('Y'), $end = date('Y') + 10; $start < $end; $start++) {
       echo "<option value=\"$start\">$start</option>\n";
       }
       ?>
       </select></td>
   </tr>

   <tr>
       <td align="center" colspan="2"><button type="submit" name="submit"
value="update">Kliknij aby sfinalizowa zamwienie</button></td>
   </tr>
</table>
</form>

<?php
// Wczenie pliku stopki w celu uzupenienia szablonu:
include_once ('./include/footer.html');

?>
