<?php # Skrypt 5.7 - cart.php

/*
 *   To jest strona obsugujca koszyk na zakupy.
 *   Strona moe dziaa w dwch ttrybach:
 *   - dodawanie towaru do koszyka,
 *   - aktualizacja koszyka
 *   Strona wywietla koszyk w postaci formularza, w ktrym mona aktualizowa iloci.
 */

 // Zaadowanie pliku konfiguracyjnego przed kodem PHP:
 require_once('./include/config.inc.php');

 // Wczenie pliku nagwkowego:
$page_title = 'Koszyk na zakupy';
 include_once ('./include/header.html');

echo '<h1>Zawarto koszyka na zakupy</h1>';

// Ta strona dodaje lub aktualizuje 
// koszyk na zakupy na podstawie wartoci zmiennej $_REQUEST['do'];
if (isset($_REQUEST['do']) && ($_REQUEST['do'] == 'dodaj') ) { // Dodanie nowego towaru.

    if (isset($_GET['id_st'])) { // Sprawdzenie identyfikatora produktu.

        // Rzutowanie wartoci na typ integer:
        $sw_id = (int) $_GET['id_st'];

        // Jeli to jest liczba cakowita,
        // pobranie informacji o pozycji:
        if ($sw_id > 0) {

            // Zdefiniowanie i wykonanie zapytania:
            $q = "SELECT nazwa, kolor, rozmiar FROM towary_ogolnie LEFT JOIN szczegoly_towarow USING
(id_ot) LEFT JOIN kolory USING (id_koloru) LEFT JOIN rozmiary USING (id_rozmiaru) WHERE id_st=$sw_id";
            $r = mysqli_query($dbc, $q);

        if (mysqli_num_rows($r) == 1) {

               // Pobranie wynikw:
               list ($name, $color, $size) = mysqli_fetch_array($r, MYSQLI_NUM);

               // Inkrementacja iloci, jeli koszyk 
               // ju zawiera taki towar:
               if (isset($_SESSION['cart'][$sw_id])) {

                   $_SESSION['cart'][$sw_id]++;

                   // Wywietlenie komunikatu:
                   echo "<p>Do koszyka dodano dodatkow kopi '$name' w kolorze $color i rozmiarze $size
.</p>\n";

                } else { // Nowa pozycja w koszyku.

                    // Dodanie do koszyka.
                    $_SESSION['cart'][$sw_id] = 1;

                    // Wywietlenie komunikatu:
                   echo "<p>Do koszyka dodano '$name' w kolorze $color i rozmiarze $size
 .</p>\n";

                }

            } // Koniec instrukcji IF mysqli_num_rows().

        } // Koniec instrukcji IF ($sw_id>0).

    } // Koniec instrukcji IF (isset($_GET['id_st']).

} elseif (isset($_REQUEST['do']) && ($_REQUEST['do'] == 'aktualizuj')) {

    // Modyfikacja iloci...
    // $k to identyfikator produktu.
    // $v to nowa ilo.
    foreach ($_POST['qty'] as $k => $v) {

       // Wartoci identyfikatora i iloci musz by liczbami cakowitymi!
       $pid = (int) $k;
       $qty = (int) $v;

       if ($qty == 0) { // Usunicie pozycji.
           unset ($_SESSION['cart'][$pid]);
       } elseif ($qty > 0) { // Modyfikacja iloci.
           $_SESSION['cart'][$pid] = $qty;
       }

     } // Koniec ptli FOREACH.

    // Wywietlenie komunikatu.
    echo '<p>Koszyk zaktualizowano.</p>';

} // Koniec instrukcji IF-ELSE $_REQUEST.

// Wywietlenie zawartoci koszyka, jeli nie jest pusty.
if (isset($_SESSION['cart']) && !empty($_SESSION['cart'])) {

    // Pobranie wszystkich informacji o produktach w koszyku:
   $q = "SELECT id_st, nazwa, kolor, rozmiar, domyslna_cena, cena FROM towary_ogolnie LEFT JOIN
szczegoly_towarow USING (id_ot) LEFT JOIN kolory USING (id_koloru) LEFT JOIN rozmiary USING (id_rozmiaru)
WHERE id_st IN (";

   // Dodanie identyfikatorw poszczeglnych produktw:
   foreach ($_SESSION['cart'] as $sw_id => $v) {
      $q .= (int) $sw_id . ',';
   }
   $q = substr ($q, 0, -1) . ') ORDER BY nazwa, rozmiar, kolor';
   $r = mysqli_query($dbc, $q);

   if (mysqli_num_rows($r) > 0) {

      // Utworzenie tabeli i formularza:
      echo '<table border="0" width="90%" cellspacing="2" cellpadding="2" align="center">
      <tr>
          <td align="left" width="20%"><b>Towar</b></td>
          <td align="left" width="15%"><b>Rozmiar</b></td>
          <td align="left" width="15%"><b>Kolor</b></td>
          <td align="right" width="15%"><b>Cena</b></td>
          <td align="center" width="10%"><b>Ilo</b></td>
          <td align="right" width="15%"><b>czna cena</b></td>
      </tr>
  <form action="cart.php" method="post">
  <input type="hidden" name="do" value="aktualizuj" />
  ';

     // Wywietlenie wszystkich pozycji:
     $total = 0; // czna warto zamwienia.
     while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {

         // Wyznaczenie ceny:
         $price = (empty($row['cena'])) ? $row['domyslna_cena'] : $row['cena'];

         // Obliczenie sumy cakowitej i sum czciowych:
         $subtotal = $_SESSION['cart'][$row['id_st']] * $price;
         $total += $subtotal;
         $subtotal = number_format($subtotal, 2);
         // Wywietlenie wiersza:
          echo <<<EOT
<tr>
    <td align="left">{$row['nazwa']}</td>
    <td align="left">{$row['rozmiar']}</td>
    <td align="left">{$row['kolor']}</td>
    <td align="right">$price PLN</td>
    <td align="center"><input type="text" size="3" name="qty[{$row['id_st']}]"
value="{$_SESSION['cart'][$row['id_st']]}" /></td>
            <td align="right">$subtotal PLN</td>
       </tr>\n
EOT;

       } // Koniec ptli WHILE.

       // Wywietlenie stopki, zamknicie tabeli i formularza:
       echo '  <tr>
          <td colspan="5" align="right"><b>Razem:<b></td>
          <td align="right">' . number_format ($total, 2) . ' PLN</td>
       </tr>
       <tr>
          <td colspan="6" align="center">Aby usun pozycj z koszyka, ustaw jej ilo na 0
.</td>
       </tr>
       </table><div align="center"><button type="submit" name="submit" value="update">Aktualizuj
koszyk</button> &nbsp; &nbsp; &nbsp; &nbsp;
       <a href="checkout.php"><button type="button" name="checkout"
value="Checkout">Do kasy</button></a></div>
    </form>';

    } // Koniec instrukcji IF mysqli_num_rows().

} else {
    echo '<p>Koszyk jest teraz pusty.</p>';
}

  // Wczenie pliku stopki w celu uzupenienia szablonu:
 include_once ('./include/footer.html');

?>
