<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//PL"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="pl">
<head>
    <meta http-equiv="content-type" content="text/html; charset=windows-1250" />
    <title>Formularz rejestracyjny</title>
</head>
<body>
<?php # Skrypt 4.1 - register.php

 /* Ten skrypt tworzy formularz rejestracyjny,
 * a nastpnie sprawdza poprawno wprowadzonych w nim danych za pomoc rnorodnych funkcji.
 */

if (isset($_POST['submitted'])) { // Obsuga formularza.

    // Zapisanie bdw w tablicy:
    $errors = array();

    // Sprawdzenie, czy nazwisko nie jest puste:
    if (!isset($_POST['name']) OR empty($_POST['name'])) {
        $errors[] = 'nazwisko';
    }

    // Sprawdzenie poprawnoci adresu e-mail za pomoc funkcji eregi():
    if (!eregi('^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$',
$_POST['email'])) {
       $errors[] = 'adres email';
    }

    // Sprawdzenie poprawnoci hasa za pomoc funkcji ctype_alnum():
    if (!ctype_alnum($_POST['pass'])) {
        $errors[] = 'haso';
    }

    // Sprawdzenie poprawnoci daty urodzenia z wykorzystaniem funkcji check_date():
    if (isset($_POST['dob']) AND
    (strlen($_POST['dob']) >= 8) AND
    (strlen($_POST['dob']) <= 10) ) {

        // Rozbicie cigu znakw na skadowe:
        $dob = explode('/', $_POST['dob']);

        // Czy funkcja zwrcia trzy czci?
        if (count($dob) == 3) {

            // Czy jest to prawidowa data?
            if (!checkdate((int) $dob[0], (int) $dob[1], (int) $dob[2])) {
                $errors[] = 'data urodzenia';
            }

        } else { // Nieprawidowy format.
            $errors[] = 'data urodzenia';
        }

    } else { // Cig pusty lub nieprawidowa dugo cigu.
        $errors[] = 'data urodzenia';
    }

    // Sprawdzenie poprawnoci numeru ICQ za pomoc funkcji ctype_digit():
    if (!ctype_digit($_POST['icq'])) {
        $errors[] = 'Numer ICQ';
    }

    // Sprawdzenie, czy uwagi nie s puste:
    if (!isset($_POST['comments']) OR empty($_POST['comments'])) {
        $errors[] = 'uwagi';
    }

    if (empty($errors)) { // Sukces!

        // Wywietlenie komunikatu i zakoczenie dziaania skryptu:
        echo '<p>Rejestracja powioda si (cho by to tylko przykad).</p></body></html>';
        exit();

    } else { // Wywietlenie komunikatu o bdach.

        echo '<p>W nastpujcych polach wystpiy bdy:<ul>';

        foreach ($errors as $error) {
            echo "<li>$error</li>\n";
        }

        echo '</ul></p>';

    }

 } // Koniec instrukcji IF $_POST['submitted'].

 // Wywietlenie formularza
?>
<form method="post">
<fieldset>
<legend>Formularz rejestracyjny</legend>
<p>Nazwisko: <input type="text" name="name" /></p>
<p>Adres e-mail: <input type="text" name="email" /></p>
<p>Haso: <input type="password" name="pass" /> (tylko litery i cyfry.)</p>
<p>Data urodzenia: <input type="text" name="dob" value="DD/MM/YYYY" /></p>
<p>Numer ICQ: <input type="text" name="icq" /></p>
<p>Uwagi: <textarea name="comments" rows="5" cols="40"></textarea></p>

<input type="hidden" name="submitted" value="true" />
<input type="submit" name="submit" value="Przelij" />
</fieldset>
</form>

</body>
</html>
