<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//PL"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="pl">
<head>
    <meta http-equiv="content-type" content="text/html; charset=windows-1250" />
    <title>Biblioteka Filter</title>
    <style type="text/css" title="text/css" media="all">
error {
   color: #F30;
}
</style>
</head>
<body>
<?php # Skrypt 4.2 - filter.php

/*  W tym skrypcie uyto funkcji biblioteki Filter
 *  do sprawdzenia poprawnoci danych formularza.
 *  Skrypt wywietla odfiltrowane dane.
 */

if (isset($_POST['submitted'])) { // Obsuga formularza.

   // Sprawdzenie poprawnoci nazwiska:
   $name = filter_input(INPUT_POST, 'name', FILTER_SANITIZE_STRING,
FILTER_FLAG_NO_ENCODE_QUOTES);
   if ($name) {
       echo "<p>Nazwisko: $name<br />\$_POST['name']: {$_POST['name']}</p>\n";
   } else {
       echo '<p class="error">Prosz wprowadzi nazwisko.</p>';
   }

    // Sprawdzenie poprawnoci adresu e-mail za pomoc staej FILTER_VALIDATE_EMAIL:
   $email = filter_input(INPUT_POST, 'email', FILTER_VALIDATE_EMAIL);
   if ($email) {
       echo "<p>Adres e-mail: $email</p>\n";
   } else {
       echo '<p class="error">Prosz wprowadzi adres e-mail.</p>';
   }

    // Sprawdzenie poprawnoci numeru ICQ za pomoc staej FILTER_VALIDATE_INT:
   $icq = filter_input(INPUT_POST, 'icq', FILTER_VALIDATE_INT);
   if ($icq) {
       echo "<p>Numer ICQ: $icq</p>\n";
   } else {
       echo '<p class="error">Prosz wprowadzi numer ICQ.</p>';
   }

   // Usunicie znacznikw ale bez kodowania apostrofw:
   $comments = filter_input(INPUT_POST, 'comments', FILTER_SANITIZE_STRING);
   if ($comments) {
       echo "<p>Uwagi: $comments<br />\$_POST['comments']: {$_POST['comments']}</p>\n";
   } else {
       echo '<p class="error">Prosz wprowadzi uwagi.</p>';
   }

 } // Koniec instrukcji IF $_POST['submitted'].

 // Wywietlenie formularza
?>
<form method="post" action="filter.php">
<fieldset>
<legend>Formularz rejestracyjny</legend>
<p>Nazwisko: <input type="text" name="name" /></p>
<p>Adres e-mail: <input type="text" name="email" /></p>
<p>Numer ICQ: <input type="text" name="icq" /></p>
<p>Uwagi: <textarea name="comments" rows="5" cols="40"></textarea></p>

<input type="hidden" name="submitted" value="true" />
<input type="submit" name="submit" value="Przelij" />
</fieldset>
</form>

</body>
</html>
