  <?php # Skrypt 2.1 - config.inc.php
  
  /* 
   *Nazwa pliku: config.inc.php
   *Utworzony przez: Larry E. Ullman z firmy DMC Insights, Inc. 
   *Kontakt: LarryUllman@DMCInsights.com, http://www.dmcinsights.com
   *Data ostatniej modyfikacji: 8 listopada 2006
   *
   *Plik konfiguracyjny spenia nastpujce zadania:
   *- Definiuje wszystkie parametry witryny w jednej lokalizacji.
   *- Zawiera adresy URL i URI w formie staych.
   *- Okrela sposb obsugi bdw.
   */
  
  # ******************** #
  # ***** PARAMETRY ***** #
  
  // Komunikaty o bdach s wysyane poczt elektroniczn.
  $contact_email = 'adres@przyklad.pl'; 
  
  // Sprawdzamy, czy skrypt pracuje na serwerze lokalnym, 
  // czy na serwerze produkcyjnym:
  if (stristr($_SERVER['HTTP_HOST'], 'local') || (substr($_SERVER['HTTP_HOST'], 0, 7) == '192.168')) {
  $local = TRUE;
  } else {
  $local = FALSE;
  }
  
  // Okrelenie lokalizacji plikw i adresu URL witryny:
  // Umoliwienie pracy na innych serwerach.
  if ($local) {
  
  //  Na serwerze lokalnym skrypt zawsze dziaa w trybie diagnostycznym::
  $debug = TRUE;
  
  // Definicja staych:
  define ('BASE_URI', '/phpulman/');
  define ('BASE_URL','http://localhost/phpulman/');
  define ('DB', '/cieka/do/mysql.inc.php');
  
  } else {
  
  define ('BASE_URI', '/cieka/do/produkcyjnego/folderu/html/');
  define ('BASE_URL','http://www.przyklad.com/');
  define ('DB', '/cieka/do/produkcyjnego/mysql.inc.php');
  
  }
  
  /* 
   *Najwaniejsze ustawienia...
   *Zmienna $debug suy do ustawienia obsugi bdw.
   *W celu debugowania okrelonej strony, naley doda poniszy kod do strony index.php:
  
  if ($p == 'thismodule') $debug = TRUE;
  require_once('./include/config.inc.php');
  
   *W celu debugowania caej witryny, nalezy ustawi zmienn $debug
  
  $debug = TRUE;
  
   *przed nastpn instrukcj warunkow.
   */
  
  // Zakadamy, e debugowanie wyczono. 
  if (!isset($debug)) {
  $debug = FALSE;
  }
  
  # ***** PARAMETRY ***** #
  # ******************** #
  
  
  # **************************** #
  # ***** OBSUGA BDW ***** #
  
  // Utworzenie procedury obsugi bdw.
  function my_error_handler ($e_number, $e_message, $e_file, $e_line, $e_vars) {
  
  global $debug, $contact_email;
  
  // Stworzenie komunikatu o bdzie.
  $message = "Wystpi bd w skrypcie '$e_file' w wierszu $e_line: \n<br />$e_message\n<br />";
  
  // Umieszczenie daty i godziny.
  $message .= "Data/godzina: " . date('n-j-Y H:i:s') . "\n<br />";
  
  // Doczenie zmiennej $e_vars do komunikatu $message.
  $message .= "<pre>" . print_r ($e_vars, 1) . "</pre>\n<br />";
  
  if ($debug) { // Wywietlenie komunikatu o bdzie.
  
  echo '<p class="error">' . $message . '</p>';
  
  } else { 
  
  // Zarejestrowanie bdu:
  error_log ($message, 1, $contact_email); // Wysanie wiadomoci email.
  
  // Wywietlenie komunikatu o bdzie tylko wtedy, gdy nie jest to bd klasy NOTICE lub STRICT.
  if ( ($e_number != E_NOTICE) && ($e_number < 2048)) {
  echo '<p class="error">Wystpi bd systemowy. Przepraszamy za niedogodnoci.</p>';
  }
  
  } // Koniec instrukcji IF $debug.
  
  } // Koniec definicji funkcji my_error_handler().
  
  // Uycie procedury obsugi bdw:
  set_error_handler ('my_error_handler');
  
  # ***** OBSUGA BDW ***** #
  # **************************** #
  
  ?>
