<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//PL"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="pl" lang="pl">
<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <title>Parser XML - Expat</title>
    <style type="text/css" title="text/css" media="all">
.tag {
      color: #00F;
}
.content {
   color: #C03;
}
.attribute {
   color: #063;
}
.avalue {
   color: #000;
}20   </style>
 </head>
 <body>
<pre>
<?php # Skrypt 14.7 - expat.php

/*   Ten skrypt parsuje dokument XML.
 *   Wykorzystano w nim bibliotek Expat - parser bazujcy na zdarzeniach.
 */

// Zdefiniowanie staych reprezentujcych 
// symbole wikszy ni i mniejszy ni.
define ('LT', '<span class="tag">&lt;');
define ('GT', '&gt;</span>');

// Funkcja obsugujca otwierajcy znacznik:
function handle_open_element ($p, $element, $attributes) {

    // Modyfikacja elementu  zamiana na same mae litery:
    $element = strtolower($element);

    // Wykonywanie rnych operacji w zalenoci od elementu:
    switch ($element) {

        case 'kolekcja':
            echo LT . $element . GT . "\n";
            break;

        case 'ksiazka': // Wcicie o dwie spacje:
            echo '  ' . LT . $element . GT . "\n";
            break;

        case 'rozdzial': // Wcicie o cztery spacje:
           echo '    ' . LT . $element;

           // Dodanie atrybutw:
           foreach ($attributes as $key => $value) {
               echo ' <span class="attribute">' . strtolower($key) . '="<span class="avalue">' . $value . '</span>"</span>';
           }
           echo GT;
           break;

        case 'okladka': // wywietlenie zdjcia.
             // Pobranie informacji o pliku graficznym:
             $image = @getimagesize ($attributes['NAZWA_PLIKU']);
             // Utworzenie elementu HTML <img>:
             echo "<img src=\"{$attributes['NAZWA_PLIKU']}\" $image[3] border=\"0\" /><br />\n";
             break;

       // Wcicie pozostaej treci o cztery spacje:
       default:
           echo '    ' . LT . $element . GT;
           break;

    } // Koniec instrukcji switch.

} // Koniec funkcji handle_open_element().

// Funkcja obsugujca zamykajcy znacznik:
function handle_close_element ($p, $element) {

    // Modyfikacja elementu  zamiana na same mae litery:
    $element = strtolower($element);

    // Wcicie zamykajcego znacznika ksiazka o 2 spacje,
    // Dla elementu okladka nie wykonujemy adnych dziaa,
    // Dla pozostaych elementw nie wykonujemy specjalnych dziaa.
    if ($element == 'ksiazka') {
        echo '  ' . LT . '/' . $element . GT . "\n";
    } elseif ($element != 'okladka') {
        echo LT . '/' . $element . GT . "\n";
    }

} // Koniec funkcji handle_close_element().

// Funkcja wywietlajca tre:
function handle_character_data ($p, $cdata) {
    echo "<span class=\"content\">$cdata</span>";
}

# ---------------------
# Koniec funkcji.
# ---------------------

 // Utworzenie parsera:
$p = xml_parser_create();

// Ustawienie funkcji obsugi parsowania:
xml_set_element_handler ($p, 'handle_open_element', 'handle_close_element');
xml_set_character_data_handler ($p, 'handle_character_data');

 // Odczytanie pliku:
$file = 'books3.xml';
$fp = @fopen ($file, 'r') or die ("Nie mona otworzy pliku o nazwie '$file'.\n</body>\n</html>\n");
while ($data = fread ($fp, filesize($file))) {
    xml_parse ($p, $data, feof($fp));
}

 // Zwolnienie zasobw zajmowanych przez parser:
xml_parser_free($p);
?>
</pre>
</body>
</html>
