#!/usr/bin/php
<?php # Skrypt 11.3 - temperatura.php


/*  Ten skrypt konwertuje temperatury pomidzy skalami
 *  Fahrenheita i Celsjusza.
 *   Skrypt jest przeznaczony do wykorzystania z interpreterem PHP w wersji CLI.
 *  Skrypt da od uytkownika podania danych wejciowych.
 */

// Wywietlenie pytania do uytkownika:
echo "\nWprowad temperatur wraz z oznaczeniem skali Fahrenheita lub Celsjusza [##.# C/F]: ";

// Odczytanie danych wejciowych w instrukcji warunkowej:
if (fscanf (STDIN, "%f %s", $temp_i, $which_i) == 2) {

    // Przeprowadzenie konwersji na podstawie zmiennej $which_i:
    switch (trim($which_i)) {

        // Stopnie Celsjusza, konwersja na Fahrenheita:
        case 'C':
        case 'c':
            $temp_o = ($temp_i * (9.0/5.0)) + 32;
            $which_o = 'F';
            $which_i = 'C';
            break;

        // Stopnie Fahrenheita, konwersja na Celsjusza :
        case 'F':
        case 'f':
            $temp_o = ($temp_i - 32) * (5.0/9.0);
            $which_o = 'C';
            $which_i = 'F';
            break;

        // Problem: uytkownik nie wprowadzi ani oznaczenia skali C ani F, ustawienie zmiennej $which_o na warto FALSE:
        default:
            $which_o = FALSE;
            break;

    } // Koniec instrukcji switch.

   // Wywietlenie wynikw:
    if ($which_o) {
        printf ("%0.1f %s to %0.1f %s.\n", $temp_i, $which_i, $temp_o, $which_o);
    } else {
        echo "Nie wprowadzono wartoci C lub F oznaczajcych biec skal temperatury.\n";
    }

} else { // Nie wprowadzono poprawnych danych wejciowych.

    echo "Uyto polecenia o nieprawidowej skadni.\n";

 } // Koniec gwnej instrukcji IF.
?>
                
