#!/usr/bin/php
<?php # Skrypt 11.2 - number2.php

/*  Ten skrypt czyta plik.
 *  Nastpnie wywietla jego zawarto wraz z numerami wierszy.
 *  Skrypt jest przeznaczony do wykorzystania z interpreterem PHP w wersji CLI.
 *  Skrypt pobiera jeden argument (oprcz nazwy skryptu):
 *  nazw skryptu do numerowania.
 */

// Upewnij si, czy podano nazw pliku.
if ($_SERVER['argc'] == 2) {

    $file = $_SERVER['argv'][1];

     // Sprawdzenie, czy argument istnieje oraz czy jest plikiem:
    if (file_exists($file) && is_file($file)) {

        // Odczytanie pliku:
        if ($data = file($file)) {

            // Wywietlenie wstpnego komunikatu.
            echo "\nNumerowanie pliku '$file'...\n------------------\n\n";

            // Licznik numerw wierszy:
            $n = 1;

            // Wywietlanie kolejnych wierszy:
            foreach ($data as $line) {

                // Wywietlanie numerw i zawartoci wierszy:
                echo "$n  $line";

                // Inkrementacja numerw wierszy:
                $n++;

            } // Koniec ptli FOREACH.

            echo "\n-------------------\nKoniec pliku '$file'.\n";

        } else {
            echo "Nie mona czyta pliku.\n";
            return 1;
        }

    } else {
        echo "Plik nie istnieje.\n";
        return 1;
    }

} else {

    // Wywietlenie informacji o sposobie uycia skryptu:
    echo "\nSposb uycia: number2.php <nazwa_pliku>\n\n";

    // Zakoczenie dziaania skryptu i zasygnalizowanie bdu.
    return 1;
}

?>
