<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//PL"
       "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="pl">
<head>
    <meta http-equiv="content-type" content="text/html; charset=windows-1250" />
    <title>Weryfikacja adresw URL</title>
    <style type="text/css" title="text/css" media="all">
.bad {
      color: #F30;
}
.good {
       color: #0C0;
}
  </style>
  </head>
 <body>
<?php # Skrypt 9.2 - check_urls.php

/*  Ten skrypt sprawdza poprawno adresw URL z podanej listy.
 *  Do tego celu wykorzystuje funkcje fsockopen() i parse_url().
 */

// Ponisza funkcja prbuje nawiza poczenie z adresem URL:
function check_url($url) {

    // Podzia adresu URL na czci skadowe:
    $url_pieces = parse_url ($url);

    // Ustawienie zmiennych $path i $port:
    $path = (isset($url_pieces['path']))? $url_pieces['path'] : '/';
    $port = (isset($url_pieces['port']))? $url_pieces['port'] : 80;

    // Nawizanie poczenia za pomoc funkcji fsockopen():
    if ($fp = @fsockopen ($url_pieces['host'], $port, $errno, $errstr, 30)) {

        // Przesanie danych:
        $send = "HEAD $path HTTP/1.1\r\n";
        $send .= "HOST: {$url_pieces['host']}\r\n";
        $send .= "CONNECTION: Close\r\n\r\n";
        fwrite($fp, $send);

        // Odczytanie odpowiedzi:
        $data = fgets ($fp, 128);

        //Zamknicie poczenia
      fclose ($fp);

        // Zwrecenie kodu odpowiedzi:
        list($response, $code) = explode (' ', $data);

        if ($code == 200) {
            return array($code, 'good');
        } else {
            return array($code, 'bad');
        }

    } else { // Brak poczenia, zwrcenie komunikatu o bdzie:
        return array($errstr, 'bad');
    }

} // Koniec funkcji check_url().

// Utworzenie listy adresw URL:
$urls = array (
'http://zirzow.dyndns.org/php-general/NEWBIE/',
'http://video.google.com/videoplay?docid=-5137581991288263801&q=loose+change',
'http://www.securephpwiki.com/index.php/Email_Injection/',
'http://www.uic.rsu.ru/doc/web/php_coding_standard.html',
'http://nfl.dmcinsights.com/MadminY/',
'http://seagull.phpkitchen.com/'
);

// Wywietlenie nagwka:
echo '<h2>Weryfikacja adresw URL</h2>';

// Usunicie limitu czasowego dla PHP:
set_time_limit(0);

// Weryfikacja poszczeglnych adresw URL:
foreach ($urls as $url) {

    list($code, $class) = check_url ($url);
    echo "<p><a href=\"$url\" target=\"_new\">$url</a> (<span class=\"$class\">$code</span>)
</p>\n";

}
?>
</body>
  </html>
