<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//PL"
       "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="pl">
<head>
    <meta http-equiv="content-type" content="text/html; charset=windows-1250" />
    <title>Obsuga wyjtkw - cz 2</title>
</head>
<body>
<?php # Skrypt 8.3 - zapis_do_pliku2.php

/* Ten skrypt podejmuje prb zapisu przykadowych danych do pliku
 * tekstowego.
 *  Do tego celu wykorzystuje si specjaln klas.
 *  Do zgaszania bdw wykorzystuje si rozszerzon klas obsugi wyjtkw.
 */

# ******************* #
# ***** KLASY ***** #

// Definicja rozszerzonej klasy obsugi wyjtkw:
// W tej klasie dodano metod get_details().
class FileException extends Exception {

   // Definicja metody get_detail()...
   // Metoda nie pobiera argumentw i
   // zwraca szczegowy komunikat.
   function get_details() {

       // Zwraca komunikat na podstawie
       // kodu:
       switch ($this->code) {
           case 0:
               return 'Nie podano nazwy pliku';
               break;
           case 1:
               return 'Plik nie istnieje.';
               break;
           case 2:
               return 'Podany argument nie jest plikiem.';
               break;
           case 3:
               return 'Brak uprawnie zapisu do pliku.';
               break;
           case 4:
               return 'Nieprawidowy tryb otwarcia pliku.';
               break;
           case 5:
               return 'Nie mona zapisa danych.';
               break;
           case 6:
               return 'Nie mona zamkn pliku.';
               break;
           default:
               return 'Dodatkowe informacje s niedostpne.';
               break;
       } // Koniec instrukcji switch.

    } // Koniec funkcji get_details().

} // Koniec klasy FileException.


// Utworzenie klasy zapisujcej dane do pliku...
// Klasa ma jeden atrybut przeznaczony do zapisania wskanika do pliku.
// Klasa zawiera konstruktor, ktry sprawdza poprawno danych
// i przypisuje wskanik.
// Klasa zawiera metod write() do zapisywania danych.
// Klasa zawiera metod close() do zamknicia wskanika.

class WriteToFile {

    // Atrybuty:
    private $fp = null;
    private $message = '';

  // Konstruktor:
    function __construct($file = null, $mode = 'w') {

        // Przypisanie nazwy pliku i trybu
        // do atrybutu message:
        $this->message = "Plik: $file Tryb: $mode";

        // Sprawdzenie, czy podano nazw pliku:
        if (empty($file)) {
            throw new FileException($this->message, 0);
        }

        // Sprawdzenie, czy plik istnieje:
        if (!file_exists($file)) {
            throw new FileException($this->message, 1);
        }

        // Sprawdzenie, czy argument jest plikiem:
        if (!is_file($file)) {
            throw new FileException($this->message, 2);
        }

        // Sprawdzenie, czy do pliku mona zapisywa dane:
        if (!is_writable($file) ) {
            throw new FileException($this->message, 3);
        }

        // Sprawdzenie poprawnoci trybu:
        if (!in_array($mode, array('a', 'a+', 'w', 'w+'))) {
             throw new FileException($this->message, 4);
        }

        // Otwarcie pliku:
        $this->fp = fopen($file, $mode);

     } // Koniec konstruktora.

    // Metoda zapisujca dane:
    function write($data = null) {

        if (!fwrite($this->fp, $data)) {
            throw new FileException($this->message . " Dane: $data", 5);
        }

    } // Koniec metody write().

    // Metoda zamykajca plik:
    function close() {

        if (!fclose($this->fp)) {
            throw new FileException($this->message, 6);
            }

        $this->fp = null;

    } // Koniec metody close().

 } // Koniec klasy WriteToFile.

 # ***** KONIEC DEFINICJI KLAS  ***** #
# ************************** #

 // Identyfikacja pliku:
 $file = 'dane.txt';

   // Dane do zapisania:
 $data = "To jest wiersz danych.\n";

 // Pocztek bloku try...catch:
 try {

    $fp = new WriteToFile($file);
    $fp->write($data);
    $fp->close();

     // Jeli doszlimy do tego punktu, to wszystko dziaa!
     echo '<p>Dane zapisano.</p>';

} catch (FileException $fe) {

    echo '<p>Procesu nie mona zakoczy. Informacje diagnostyczne:<br />' .
$fe->getMessage() . '<br />' . $fe->get_details() . '</p>';

}


?>
</body>
</html>