<?php # Skrypt 5.1 - config.inc.php

/*
 *Plik konfiguracyjny spenia nastpujce zadania:
 *- Definiuje wszystkie parametry witryny w jednej lokalizacji.
 *- Zawiera adresy URL i URI w formie staych.
 *- Okrela sposb obsugi bdw.
 *  - Nawizuje poczenie z baz danych.
 */


 # ******************** #
 # ***** PARAMETRY ***** #

 // Komunikaty o bdach s wysyane poczt elektroniczn.
 $contact_email = 'address@przyklad.com'; 

 // Sprawdzamy, czy skrypt pracuje na serwerze lokalnym, 
 // czy na rzeczywistym serwerze:
if (stristr($_SERVER['HTTP_HOST'], 'local') || (substr($_SERVER['HTTP_HOST'], 0, 7) ==     '192.168')) {
    $local = TRUE;
} else {
    $local = FALSE;
}

 // Okrelenie lokalizacji plikw i adresu URL witryny:
 // Umoliwienie pracy na innych serwerach.
 if ($local) {

 //  Na serwerze lokalnym skrypt zawsze dziaa w trybie diagnostycznym:
    $debug = TRUE;

    // Zdefiniowanie staych:
    define ('BASE_URI', '/cieka/do/folderu/html/');
    define ('BASE_URL','http://localhost/katalog/');

} else {

    define ('BASE_URI', '/cieka/do/produkcyjnego/folderu/html/');
    define ('BASE_URL', 'http://www.przyklad.com/');

}

/*
  *Najwaniejsze ustawienia...
  *Zmienna $debug suy do ustawienia obsugi bdw.
  * W celu debugowania okrelonej strony, naley wykona poniszy kod:

 $debug = TRUE;
 require_once('./includes/config.inc.php');

 *  na tej stronie.
 *
 * W celu debugowania caej witryny, nalezy ustawi zmienn $debug

$debug = TRUE;

  *przed nastpn instrukcj warunkow.
  */

 // Zakadamy, e debugowanie wyczono.
 if (!isset($debug)) {
 $debug = TRUE;
}

 # ***** PARAMETRY ***** #
 # ******************** #


# **************************** #
 # ***** OBSUGA BDW ***** #

 // Utworzenie procedury obsugi bdw.
 function my_error_handler ($e_number, $e_message, $e_file, $e_line, $e_vars) {

 global $debug, $contact_email;

 // Stworzenie komunikatu o bdzie.
    $message = "Wystpi bd w skrypcie '$e_file' w wierszu $e_line: \n<br />$e_message\n<br     />";

    // Umieszczenie daty i godziny.
 $message .= "Data/godzina: " . date('n-j-Y H:i:s') . "\n<br />";

    // Doczenie zmiennej $e_vars do komunikatu $message.
    $message .= "<pre>" . print_r ($e_vars, 1) . "</pre>\n<br />";

    if ($debug) { // Wywietlenie komunikatu o bdzie.

       echo '<p class="error">' . $message . '</p>';

    } else {

        // Zarejestrowanie bdu:
        error_log ($message, 1, $contact_email); // Wysanie wiadomoci email.

        // Wywietlenie komunikatu o bdzie tylko wtedy, gdy nie jest to bd klasy NOTICE lub STRICT.
        if ( ($e_number != E_NOTICE) && ($e_number < 2048)) {
            echo '<p class="error">Wystpi bd systemowy. Przepraszamy za niedogodnoci.</p>';
       }

  } // Koniec instrukcji IF $debug.

  } // Koniec definicji funkcji my_error_handler().

  // Uycie procedury obsugi bdw:
  set_error_handler ('my_error_handler');

  # ***** OBSUGA BDW ***** #
# **************************** #


# ************************** #
# ***** OBSUGA BAZY DANYCH ***** #

  // Nawizanie poczenia z baz danych.
 $dbc = @mysqli_connect ('localhost', 'root', '', 'ecommerce') OR trigger_error("Nie mona nawiza poczenia z baz danych!\n<br />Bd MySQL: " . mysqli_connect_error());

// Utworzenie funkcji do obsugi znakw specjalnych wewntrz danych.
function escape_data ($data) {

    //Potrzebne poczenie:
    global $dbc;

    // Sprawdzenie opcji magic_quotes.
    if (ini_get('magic_quotes_gpc')) {
        $data = stripslashes($data);
    }

    // Obcicie spacji i obsuga znakw specjalnych:
    return mysqli_real_escape_string($dbc, trim($data));

} // Koniec funkcji escape_data().

# ***** OBSUGA BAZY DANYCH ***** #
# ************************** #

?>
