<?php # Skrypt 8.4  WidgetShoppingCart.php

/*  Skrypt definiuje klas WidgetShoppingCart.
*  Klasa zawiera jeden atrybut: tablic o nazwie $items.
 *   Klasa zawiera pi metod:
 *   - is_empty()
 *   - add_item()
 *   - update_item()
 *   - delete_item()
 *   - display_cart()
 */

class WidgetShoppingCart {

    // Atrybut:
    protected  $items = array();


    // Metoda zwracajca warto typu Boolean
    // wskazujc na to, czy koszyk jest pusty:
    public function is_empty() {
        if (empty($this->items)) {
            return true;
        } else {
            return false;
        }
    }


    // Metoda dodajca towar do koszyka.
    // Pobiera dwa argumenty: the item ID and an array of info.
    public function add_item($id, $info) {

        // Czy towar jest ju w koszyku?
        if (isset($this->items[$id])) {

            // Wywoanie metody update_item():
            $this->update_item($id, $this->items[$id]['qty'] + 1);

        } else {

            // Dodanie tablicy z informacjami:
            $this->items[$id] = $info;

            // Dodanie iloci.
            $this->items[$id]['qty'] = 1;

            // Wywietlenie komunikatu.
            echo "<p>Towar '{$info['nazwa']}' w kolorze {$info['kolor']}, rozmiarze {$info['rozmiar']} dodano do koszyka na zakupy.</p>\n";

       }

   } // Koniec metody add_item().


   // Metoda aktualizujca pozycj w koszyku.
   // Pobiera dwa argumenty: identyfikator pozycji i ilo.
   public function update_item($id, $qty) {

       // Usu, jeli $qty wynosi 0:
       if ($qty == 0) {

           $this->delete_item($id);

       } elseif ( ($qty > 0) && ($qty != $this->items[$id]['qty'])) {

           // Aktualizacja.
           $this->items[$id]['qty'] = $qty;

            // Wywietlenie komunikatu.
           echo "<p>Teraz jest $qty kopii towaru '{$this->items[$id]['nazwa']}' w kolorze {$this->items[$id]['kolor']}, rozmiarze {$this->items[$id]['rozmiar']} w koszyku na zakupy.</p>\n";

       }

   } // Koniec metody update_item().


   // Metoda usuwajca pozycj w koszyku.
   // Pobiera jeden argument: identyfikator towaru.
   public function delete_item($id) {

       // Potwierdzenie, e towar jest w koszyku:
       if (isset($this->items[$id])) {
         // Wywietlenie komunikatu.

       echo "<p>Towar '{$this->items[$id]['nazwa']}' w kolorze {$this->items[$id]['kolor']}, rozmiarze {$this->items[$id]['rozmiar']} usunito z koszyka na zakupy.</p>\n";

            // Usunicie towaru:
            unset($this->items[$id]);

        }

   } // Koniec metody delete_item().


   // Metoda wywietlajca zawarto koszyka:
    // Pobiera jeden argument: warto argumentu action formularza.
    public function display_cart($action = false) {

        // Wywietlenie tabeli:
      echo '<table border="0" width="90%" cellspacing="2" cellpadding="2" align="center">
        <tr>
           <td align="left" width="20%"><b>Towar</b></td>
          <td align="left" width="15%"><b>Rozmiar</b></td>
          <td align="left" width="15%"><b>Kolor</b></td>
          <td align="right" width="15%"><b>Cena</b></td>
          <td align="center" width="10%"><b>Ilo</b></td>
          <td align="right" width="15%"><b>czna cena</b></td>
   </tr>
  ';

       // Wywietlenie kodu formularza, jeli jest taka potrzeba.
       if ($action) {
         echo '<form action="' . $action . '" method="post">
       <input type="hidden" name="do" value="aktualizuj" />
       ';
        }

        // Zainicjowanie zmiennej $total:
        $total = 0;

        // Przetwarzanie w ptli wszystkich pozycji:
        foreach ($this->items as $id => $info) {

            // Obliczenie sumy cakowitej i sum czciowych:
            $subtotal = $info['qty'] * $info['cena'];
            $total += $subtotal;
            $subtotal = number_format($subtotal, 2);

            // Okrelenie sposobu wywietlenia iloci:
           
            $qty = ($action) ? "<input type=\"text\" size=\"3\" name=\"qty[$id]\" value=\"{$info['qty']}\" />" :  $info['qty'];

            // Wywietlenie wiersza:
            echo <<<EOT
<tr>
   <td align="left">{$info['nazwa']}</td>
    <td align="left">{$info['rozmiar']}</td>
   <td align="left">{$info['kolor']}</td>
   <td align="right">{$info['cena']} PLN</td>
   <td align="center">$qty</td>
            <td align="right">$subtotal PLN</td>
        </tr>\n
EOT;

        } // Koniec ptli FOREACH.

        // Zakoczenie tabeli
        echo '   <tr>
          <td colspan="5" align="right"><b>Razem:<b></td>
            <td align="right">' . number_format ($total, 2) . ' PLN</td>
        </tr>';

        // Zakoczenie formularza, jeli jest taka potrzeba
       if ($action) {
            echo '<tr>
          <td colspan="6" align="center">Aby usun pozycj z koszyka, ustaw jej ilo na 0 .</td>
   </tr>
<tr>
    <td colspan="6" align="center"><button type="submit" name="submit" value="aktualizuj">Aktualizuj koszyk</button></td>
    </tr>
    </form>';
        }

      echo '</table>';

    } // Koniec metody display_cart().

 } // Koniec klasy WidgetShoppingCart.

?>
