<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//PL"
       "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="pl">
<head>
    <meta http-equiv="content-type" content="text/html; charset=windows-1250" />
    <title>Zwierzaki</title>
</head>
<body>
<?php # Skrypt 7.6 - static.php

 /*  Skrypt definiuje i korzysta z klas
 *  Zwierzak, Kot i Pies.
 */

# ******************* #
# ***** KLASY ***** #

/* Klasa Zwierzak.
  *   Klasa zawiera dwa atrybuty:
 *  - protected $imie
 *  - private static $licznik
  *   Klasa zawiera trzy metody:
 *  - __construct()
 *  - __destruct()
 *  - public static pobierz_licznik()
 */
class Zwierzak {

    // Deklaracja atrybutw:
    protected $imie;

    private static $licznik = 0;

   // Konstruktor przypisuje imi zwierzakowi:
    // i inkrementuje licznik:
   function __construct($imie_zwierzaka) {

        $this->imie = $imie_zwierzaka;

        // Inkrementacja licznika:
        self::$licznik++;

    }
      // Destruktor dekrementuje licznik:
   function __destruct() {
        self::$licznik--;
    }

    // Metoda statyczna zwracajca licznik:
    public static function pobierz_licznik() {
        return self::$licznik;
    }

} // Koniec klasy Zwierzak.


/* Klasa Kot jest rozszerzeniem klasy Zwierzak. */
 class Kot extends Zwierzak {
} // Koniec klasy Kot.

/* Klasa Pies jest rozszerzeniem klasy Zwierzak. */
 class Pies extends Zwierzak {
} // Koniec klasy Pies.

/* Klasa Fretka  jest rozszerzeniem klasy Zwierzak. */
 class Fretka extends Zwierzak {
} // Koniec klasy Fretka.

/* Klasa Sowa  jest rozszerzeniem klasy Zwierzak. */
class Sowa extends Zwierzak {
} // Koniec klasy Sowa.


# ***** KONIEC DEFINICJI KLAS  ***** #
# ************************** #

// Utworzenie obiektu Pies:
$pies = new Pies('Panda');

// Wywietlenie liczby zwierzakw:
echo '<p>Po utworzeniu psa jest ' . Zwierzak::pobierz_licznik() . ' zwierzakw.</p>';

// Utworzenie obiektu Kot:
$kot = new Kot('Mruczek');
echo '<p>Po utworzeniu kota jest ' . Zwierzak::pobierz_licznik() . ' zwierzakw.</p>';

// Utworzenie innego zwierzaka:
$fretka = new Fretka('Frania');
echo '<p>Po utworzeniu fretki jest ' . Zwierzak::pobierz_licznik() . ' zwierzakw.</p>';

// Wypadek!
unset($pies);
echo '<p>Po wypadku jest ' . Zwierzak::pobierz_licznik() . ' zwierzakw.</p>';

// Sowy s bardzo mie:
$sowa = new Sowa('Teodozja');
echo '<p>Po utworzeniu sowy jest ' . Zwierzak::pobierz_licznik() . ' zwierzakw.</p>';

  // Usunicie obiektw:
unset($kot, $fretka, $sowa);

?>
  </body>
  </html>
