<?php # Skrypt 7.8 - trojkat.php

/*  Skrypt definiuje klas Trojkat
 *   Klasa zawiera dwa atrybuty:
 *   - private $boki (tablica)
 *   - private $obwod (liczba)
 *   Klasa zawiera trzy metody:
*  - __construct()
 *   - oblicz_pole()
  *   - oblicz_obwod()
 */
require_once('Figura.php');
class Trojkat extends Figura {

    // Deklaracja atrybutw:
    private $boki = array();
    private $obwod = NULL;

  // Konstruktor:
    function __construct($s0 = 0, $s1 = 0, $s2 = 0) {

        // Zapisanie wartoci w tablicy:
        $this->boki[] = $s0;
        $this->boki[] = $s1;
        $this->boki[] = $s2;

        // Obliczenie obwodu:
        $this->obwod = array_sum($this->boki);

    } // Koniec konstruktora.

    // Metoda obliczajca i zwracajca pole powierzchni:
    public function oblicz_pole() {

        // Obliczenie i zwrcenie pola powierzchni:
        return (SQRT(
        ($this->obwod/2) *
        (($this->obwod/2) - $this->boki[0]) *
        (($this->obwod/2) - $this->boki[1]) *
        (($this->obwod/2) - $this->boki[2])
        ));

    } // Koniec metody oblicz_pole().

    // Metoda zwracajca obwd:
    public function oblicz_obwod() {
        return $this->obwod;
    } // Koniec metody oblicz_obwod().

} // Koniec klasy Trojkat.

?>
