<?php # Skrypt 5.6 - product.php

/*
 *    To jest strona wywietlajca informacje o produkcie,
 *  ktra pokazuje wszystkie szczegowe
 *  produkty dostpne dla wybranej wartoci zmiennej $_GET['id_ot'].
 *  cza na stronie umoliwiaj dodawanie pozycji do koszyka.
 */

 // Zaadowanie pliku konfiguracyjnego przed kodem PHP:
 require_once('./include/config.inc.php');

// Sprawdzenie, czy w adresie URL przekazano oglny identyfikator produktu:
$name = NULL;

if (isset($_GET['id_ot'])) {

    // Rzutowanie wartoci na typ integer:
    $gw_id = (int) $_GET['id_ot'];

    // Zmienna $gw_id musi mie prawidow warto.
    if ($gw_id > 0) {

        // Pobranie informacji z bazy danych
        // dla okrelonego produktu:
                mysqli_query($dbc,'SET CHARACTER cp1250');
                mysqli_query($dbc,'SET NAMES cp1250');	 
                mysqli_query($dbc,'SET CHARACTER_SET cp1250');

        $q = "SELECT nazwa, domyslna_cena, opis FROM towary_ogolnie WHERE id_ot=$gw_id";
        $r = mysqli_query($dbc, $q);

        if (mysqli_num_rows($r) == 1) {
            list ($name, $price, $description) = mysqli_fetch_array($r, MYSQLI_NUM);
        } // Koniec instrukcji IF mysqli_num_rows().

    } // Koniec instrukcji IF ($gw_id>0).

} // Koniec instrukcji IF (isset($_GET['id_ot']).

// Wykorzystanie nazwy produktu jako tytuu strony:

if ($name) {
    $page_title = $name;
}
 // Wczenie pliku nagwkowego:
 include_once ('./include/header.html');

if ($name) { // Wywietlenie szczegowych produktw.

    echo "<h1>$name</h1>\n";

    // Wywietlenie opisu produktu, jeli to pole nie jest puste.
    if (!empty($description)) {
        echo "<p>$description</p>\n";
    }

    // Pobranie szczegowych towarw dla podanego identyfikatora oglnego.
    $q = "SELECT id_st, kolor, rozmiar, cena, w_magazynie FROM szczegoly_towarow LEFT JOIN kolory using
(id_koloru) LEFT JOIN rozmiary USING (id_rozmiaru) WHERE id_ot=$gw_id ORDER BY rozmiar, kolor";
        $r = mysqli_query($dbc, $q);

    if (mysqli_num_rows($r) > 1) {

        // Wywietlenie danych o kadym z towarw:
        echo '<h3>Dostpne rozmiary i kolory</h3>';

        while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {

            // Wyznaczenie ceny:
            $price = (empty($row['cena'])) ? $price : $row['cena'];
            $mag = $row['w_magazynie']=='Y' ? 'Tak' : 'Nie';

            // Wywietlenie wikszej czci informacji:
            echo "<p>Rozmiar: {$row['rozmiar']}<br />Kolor: {$row['kolor']}<br /> Cena: $price PLN<br
 />Dostpny w magazynie?: $mag";

            // Wywietlenie cza umoliwiajcego dodanie towaru do koszyka.
            if ($row['w_magazynie'] == 'Y') {
                echo "<br /> <a href=\"cart.php?id_st={$row['id_st']}&do=dodaj\">Dodaj do koszyka</a>";
            }

            echo '</p>';

        } // Koniec ptli WHILE.

    } else { // Brak szczegowych towarw o tej wartoci identyfikatora oglnego!
       echo '<p class="error">Obecnie nie ma w magazynie towarw
tego rodzaju.</p>';
    }

} else { // Niepoprawna warto $_GET['id_ot']!
    echo '<p class="error">Prba niewaciwego dostpu do strony.</p>';
}

 // Wczenie pliku stopki w celu uzupenienia szablonu:
include_once ('./include/footer.html');

?>
