<?php # Skrypt 5.5 - category.php

/*
 *  Ta strona reprezentuje okrelone kategorie.
 *  Wywietlaj si na niej wszystkie towary sklasyfikowane
 *  w ramach kategorii.
 *  Strona pobiera warto zmiennej $_GET['cid'].
 */

 // Zaadowanie pliku konfiguracyjnego przed kodem PHP:
 require_once('./include/config.inc.php');

// Sprawdzenie, czy w adresie URL przekazano identyfikator kategorii:
$category = NULL;
if (isset($_GET['cid'])) {

    // Rzutowanie wartoci na typ integer:
    $cid = (int) $_GET['cid'];
    // Nieprawidowa warto $_GET['cid'] bdzie
    // przeksztacona na 0.

    // Zmienna $cid musi mie prawidow warto.
    if ($cid > 0) {

        // Pobranie informacji z bazy danych
        // dla okrelonej kategorii:
        mysqli_query($dbc,'SET CHARACTER cp1250');
        mysqli_query($dbc,'SET NAMES cp1250');	 
        mysqli_query($dbc,'SET CHARACTER_SET cp1250');

        $q = "SELECT kategoria, opis FROM kategorie WHERE id_kategorii=$cid";
        $r = mysqli_query($dbc, $q);

        // Pobranie wynikw:
        if (mysqli_num_rows($r) == 1) {
            list ($category, $description) = mysqli_fetch_array($r, MYSQLI_NUM);
        } // Koniec instrukcji IF mysqli_num_rows().

    } // Koniec instrukcji IF ($cid>0).

} // Koniec instrukcji IF ($_GET['cid']).

// Wykorzystanie kategorii w roli tytuu strony:
if ($category) {
    $page_title = $category;
}

 // Wczenie pliku nagwkowego:
 include_once ('./include/header.html');

if ($category) { // Wywietlenie towarw.

    echo "<h1>$category</h1>\n";

    // Wywietlenie opisu kategorii, jeli to pole nie jest puste.
    if (!empty($description)) {
        echo "<p>$description</p>\n";
    }

    // Pobranie towarw z okrelonej kategorii:
    $q = "SELECT id_ot, nazwa, domyslna_cena, opis FROM towary_ogolnie WHERE
id_kategorii=$cid";
    $r = mysqli_query($dbc, $q);

    if (mysqli_num_rows($r) > 1) {

        // Wywietlenie danych o kadym z towarw:
        while (list($gw_id, $wname, $wprice, $wdescription) = mysqli_fetch_array($r, MYSQLI_NUM))
{

            // cze do strony product.php:
            echo "<h2><a href=\"product.php?id_ot=$gw_id\">$wname</a></h2><p>$wdescription<br
/>$wprice PLN</p>\n";

        } // Koniec ptli while.

    } else { // Brak towarw w tej kategorii!
        echo '<p class="error">W tej kategorii nie ma adnych towarw.</p>';
    }

} else { // Nieprawidowa warto zmiennej $_GET['cid']!
    echo '<p class="error">Prba niewaciwego dostpu do strony.</p>';
}

 // Wczenie pliku stopki w celu uzupenienia szablonu:
 include_once ('./include/footer.html');

?>
