<?php # Skrypt 3.1 - db_sessions.inc.php

/*
 *  Ten skrypt tworzy interfejs funkcjonalny
 *  do zapisywania danych sesji 
 *  w bazie danych.
 *  Oprcz tego ten skrypt rozpoczyna sesj.
 */

// Zmienna globalna uywana do zapisania danych
// o poczeniu z baz danych we wszystkich funkcjach obsugi sesji:
$sdbc = NULL;

// Definicja funkcji open_session():
// Funkcja nie pobiera argumentw.
// Jej zadanie polega na otwarciu poczenia z baz danych.
function open_session() {

    global $sdbc;

    // Nawizanie poczenia z baz danych.
    $sdbc = mysqli_connect ('localhost', 'root', '', 'test') OR die ('Nie mona poczy si z baz danych.');

    return true;

} // Koniec funkcji open_session().
  // Definicja funkcji close_session():

  // Funkcja nie pobiera argumentw.
  // Jej zadanie polega na zamkniciu poczenia z baz danych.
  function close_session() {

    global $sdbc;

    return mysqli_close($sdbc);

} // Koniec funkcji close_session().

  // Definicja funkcji read_session():
  // Funkcja pobiera jeden argument: Identyfikator sesji
  // Funkcja odczytuje dane sesji.
  function read_session($sid) {

    global $sdbc;

     // Wysanie zapytania do bazy danych.
    $q = sprintf('SELECT dane FROM sesje WHERE id="%s"', mysqli_real_escape_string($sdbc, $sid));
    $r = mysqli_query($sdbc, $q);

     // Odczytanie wynikw:
    if (mysqli_num_rows($r) == 1) {

        list($data) = mysqli_fetch_array($r, MYSQLI_NUM);

        // Zwrcenie danych:
        return $data;

    } else { // Zwrcenie pustego cigu.
        return '';
    }

} // Koniec funkcji read_session().

// Definicja funkcji write_session():
// Funkcja pobiera dwa argumenty:
// identyfikator sesji i dane sesji.
function write_session($sid, $data) {

    global $sdbc;

    // Zapisanie danych w bazie danych.
    $q = sprintf('REPLACE INTO sesje (id, dane) VALUES ("%s", "%s")',
mysqli_real_escape_string($sdbc, $sid), mysqli_real_escape_string($sdbc, $data));
    $r = mysqli_query($sdbc, $q);

   return mysqli_affected_rows($sdbc);

} // Koniec funkcji write_session().

// Definicja funkcji destroy_session():
// Funkcja pobiera jeden argument: Identyfikator sesji
function destroy_session($sid) {

    global $sdbc;

    // Usunicie danych z bazy danych.
    $q = sprintf('DELETE FROM sesje WHERE id="%s"', mysqli_real_escape_string($sdbc, $sid));
    $r = mysqli_query($sdbc, $q);

    // Wyzerowanie tablicy $_SESSION:
    $_SESSION = array();

    return mysqli_affected_rows($sdbc);

} // Koniec funkcji destroy_session().

// Definicja funkcji clean_session():
// Funkcja pobiera jeden argument: warto w sekundach.
function clean_session($expire) {

    global $sdbc;

    // Usunicie starych sesji:
    $q = sprintf('DELETE FROM sesje WHERE DATE_ADD(ostatni_dostep, INTERVAL %d SECOND) <     NOW()', (int) $expire);
    $r = mysqli_query($sdbc, $q);

    return mysqli_affected_rows($sdbc);

 } // Koniec funkcji clean_session().

 # **************************** #
 # ***** KONIEC FUNKCJI   ***** #
 # **************************** #

 // Deklaracja uywanych funkcji:
 session_set_save_handler('open_session', 'close_session', 'read_session', 'write_session', 'destroy_session', 'clean_session');

 // Wprowadzenie innych zmian do ustawie sesji.

 // Rozpoczcie sesji:
 session_start();

 ?>
