<?php
class Book extends DOMElement {
  private $document;

  public function __construct(DOMDocument $document) {
    parent::__construct('book');
    $this->document = $document;
  }

  public function setAuthor($author) {
    $this->appendChild(
      $this->document->createElement(
        'author',
        $author
      )
    );
  }

  public function setISBN($isbn) {
    $this->appendChild(
      $this->document->createElement(
        'isbn',
        $isbn
      )
    );
  }

  public function setLanguage($language) {
    $this->setAttribute('lang', $language);
  }

  public function setTitle($title) {
    $this->appendChild(
      $this->document->createElement(
        'title',
        $title
      )
    );
  }
}
?>
