<?php
class MojSQLi_Exception extends Exception {
}

class MojSQLi_ConnectionException extends MojSQLi_Exception {
}

class MojSQLi_QueryException extends MojSQLi_Exception {
}

class Moj_MySQLi extends MySQLi {
  public function __construct(
    $nazwaHosta, $nazwaUzytkownika = '', $haslo = '',
    $nazwaBazy = '', $port = 3306, $gnizado = '') {
    parent::__construct(
      $nazwaHosta,
      $nazwaUzytkownika,
      $haslo,
      $nazwaBazy,
      $port,
      $gnizado
    );

    if (mysqli_connect_error()) {
      throw new MojSQLi_ConnectionException(
        mysqli_connect_error(),
        mysqli_connect_errno()
      );
    }
  }

  public function zapytanie($zapytanie) {
    $wynik = parent::zapytanie($zapytanie);

    if ($this->error) {
      throw new MojSQLi_QueryException(
        $this->error,
        $this->errno
      );
    }
  }
}
?>
