<?php
require_once 'StringIterator.php';

class StringFilterIterator extends FilterIterator {
  private $prefix;

  public function
  __construct(StringIterator $stringIterator, $prefix) {
    parent::__construct($stringIterator);
    $this->prefix = $prefix;
  }

  public function accept() {
    $current = $this->getInnerIterator()->current();

    if (strpos($current, $this->prefix) === 0) {
      return TRUE;
    }

    return FALSE;
  }
}

$stringIterator = new StringIterator('Foo Bar Barbara');
$filterIterator = new StringFilterIterator(
  $stringIterator,
  'Bar'
);

foreach ($filterIterator as $klucz => $wartosc) {
    print "$wartosc\n";
}
?>
