<?php
require_once 'StrategiaPorownania.php';
require_once 'PorownanieRosnace.php';
require_once 'PorownanieMalejace.php';

class SortowanieBabelkowe {
  private $strategia;

  public function setStrategy(StrategiaPorownania $strategy) {
    $this->strategia = $strategia;
  }

  public function sortuj($tablica) {
    for ($i = sizeof($tablica)-1; $i >= 0; --$i) {
      for ($j = 0; $j < $i; ++$j ) {
        $cmp = $this->strategia->porownaj(
          $tablica[$j],
          $tablica[$j+1]
        );

        if ($cmp > 0) {
          $tmp           = $tablica[$j];
          $tablica[$j]   = $tablica[$j+1];
          $tablica[$j+1] = $tmp;
        }
      }
    }

    return $tablica;
  }
}

$bs = new SortowanieBabelkowe;

$bs->setStrategy(new PorownanieRosnace);
print_r($bs->sortuj(array(22, 4, 1978)));

$bs->setStrategy(new PorownanieMalejsce);
print_r($bs->sortuj(array(22, 4, 1978)));
?>
