<?php
require_once 'PHPUnit2/Util/CodeCoverage/Renderer.php';

class PHPUnit2_Extensions_CodeCoverage_Renderer_Text
extends PHPUnit2_Extensions_CodeCoverage_Renderer {
  protected function startTestCase($testCaseName) {
    return $testCaseName . "\n\n";
  }

  protected function endTestCase($testCaseName) {
    return "\n";
  }

  protected function startSourceFile($sourceFile) {
    return '  ' . $sourceFile . "\n\n";
  }

  protected function endSourceFile($sourceFile) {
    return "\n";
  }

  protected function renderSourceFile($codeLines, $executedLines) {
    $buffer = '';
    $line   = 1;

    foreach ($codeLines as $codeLine) {
      $buffer .= sprintf(
        '    %4u|%4s| %s',

        $line,
        (isset($executedLines[$line])) ? $executedLines[$line] . 'x' : '',
        $codeLine
      );

      $line++;
    }

    return $buffer;
  }
}
?>
