<?php
class Ksiazki {
  protected $parser;
  protected $stosElementow = array();
  protected $autorzy = array();

  public function __construct() {
    $this->parser = xml_parser_create();

    xml_set_object($this->parser, $this);

    xml_set_element_handler(
      $this->parser,
      'startElement',
      'endElement'
    );

    xml_set_character_data_handler(
      $this->parser,
      'characterData'
    );

    xml_set_default_handler(
      $this->parser,
      'characterData'
    );
  }

  public function __destruct() {
    xml_parser_free($this->parser);
  }

  public function odczytajKatalog($katalog) {
    xml_parse(
      $this->parser,
      file_get_contents($katalog),
      TRUE
    );
  }

  protected function
  startElement($parser, $element, $attributes) {
    array_push($this->stosElementow, $element);

    if ($element == 'BOOK') {
      $this->autorzy = array();
    }
  }

  protected function endElement($parser, $element) {
    array_pop($this->stosElementow);
  }

  protected function characterData($parser, $cdata) {
    $poziom   = sizeof($this->stosElementow) - 1;
    $element = $this->stosElementow[$poziom];

    switch($element) {
        case 'AUTHOR': {
          $this->autorzy[] = $cdata;
        }
        break;

        case 'TITLE': {
          print implode(', ', $this->autorzy) . "\n";
          print $cdata . "\n";
        }
        break;

        case 'ISBN': {
          print 'ISBN: ' . $cdata . "\n\n";
        }
        break;
    }
  }
}

$ksiazki = new Ksiazki;
$ksiazki->odczytajKatalog('books.xml');
?>
