<?php
require_once 'Book.php';

class Books extends DOMDocument {
  private $books;

  public function __construct() {
    parent::__construct('1.0', 'iso-8859-2');

    $this->books = $this->appendChild(
      $this->createElement('books')
    );

    $this->formatOutput = TRUE;
  }

  public function createBook() {
    $book = new Book($this);
    $this->books->appendChild($book);

    return $book;
  }
}

$books = new Books;
$book  = $books->createBook();

$book->setAuthor('Sebastian Bergmann');
$book->setISBN('3-89864-229-1???');
$book->setTitle(
  'Profesjonalne tworzenie oprogramowania w PHP 5'
);
$book->setLanguage('pl');

print $books->saveXML();
?>
